use strict;
use warnings;

use Module::Build 0.4004;

sub whimper { print {*STDOUT} $_[ 0 ]."\n"; exit 0 }

my $perl_ver = 5.008;
my $name     = 'Dist-Zilla-Plugin-ManifestInRoot'; $name =~ s{ - }{::}gmx;
my $prereqs  = {
  'build_requires' => {
    'Dist::Zilla' => '4.300033',
    'Module::Build' => '0.4004',
    'Test::Requires' => '0.06',
    'version' => '0.88'
  },
  'configure_requires' => {
    'Module::Build' => '0.4004',
    'version' => '0.88'
  },
  'requires' => {
    'Dist::Zilla' => '4.300033',
    'Moose' => '2.0802',
    'Moose::Autobox' => '0.12',
    'namespace::autoclean' => '0.13',
    'perl' => '5.008',
    'version' => '0.88'
  }, };

unless ($] >= $perl_ver) {
   $ENV{AUTOMATED_TESTING}
      or $ENV{PERL_CPAN_REPORTER_CONFIG}
      or $ENV{PERL5_CPANPLUS_IS_VERSION}
      or whimper "Minimum required Perl version is ${perl_ver}";
   $prereqs->{build_requires} = { %{ $prereqs->{configure_requires} } };
   $prereqs->{build_requires}->{ 'Test::Requires' } = 0.06;
   delete $prereqs->{requires};
}

Module::Build->new(
  'module_name' => $name,
  'notes'       => { min_perl_version => $perl_ver },
  %{ $prereqs },

)->create_build_script;

exit 0;
