package t::boilerplate;

use strict;
use warnings;
use File::Spec::Functions qw( catdir updir );
use FindBin               qw( $Bin );
use lib               catdir( $Bin, updir, 'lib' ), catdir( $Bin, 'lib' );

use Test::More;
use Test::Requires { version => 0.88 };
use Module::Build;
use Sys::Hostname;

my ($builder, $host, $notes, $perl_ver);

BEGIN {
   $host     = lc hostname;
   $builder  = eval { Module::Build->current };
   $notes    = $builder ? $builder->notes : {};
   $perl_ver = $notes->{min_perl_version} || 5.008;

   if ($notes->{testing}) {
      $Bin =~ m{ : .+ : }mx and plan skip_all => 'Two colons in $Bin path';
   }

   # Not possible to detect smoking
   # Smoker has two colons in Dist::Zilla::Test rootdir path
   $host eq 'w5050029'   and plan skip_all => 'Broken smoker';
   $host eq 'w5139020'   and plan
      skip_all => 'Broken smoker 85ab240c-6bfd-1014-828b-aa2bd4cf89d2';
}

use Test::Requires "${perl_ver}";

sub import {
   strict->import;
   $] < 5.008 ? warnings->import : warnings->import( NONFATAL => 'all' );
   return;
}

1;

# Local Variables:
# mode: perl
# tab-width: 3
# End:
# vim: expandtab shiftwidth=3:
