#!/usr/bin/env perl

use strict;
use warnings;

use Lingua::EUS::Numbers qw(cardinal2alpha);
use Test::More tests => 156;

my %list = (
0 => 'zero',
1 => 'bat',
2 => 'bi',
3 => 'hiru',
4 => 'lau',
5 => 'bost',
6 => 'sei',
7 => 'zazpi',
8 => 'zortzi',
9 => 'bederatzi',
10 => 'hamar',
11 => 'hamaika',
12 => 'hamabi',
13 => 'hamahiru',
14 => 'hamalau',
15 => 'hamabost',
16 => 'hamasei',
17 => 'hamazazpi',
18 => 'hemezortzi',
19 => 'hemeretzi',
20 => 'hogei',
21 => 'hogeita bat',
22 => 'hogeita bi',
23 => 'hogeita hiru',
24 => 'hogeita lau',
25 => 'hogeita bost',
26 => 'hogeita sei',
27 => 'hogeita zazpi',
28 => 'hogeita zortzi',
29 => 'hogeita bederatzi',
30 => 'hogeita hamar',
31 => 'hogeita hamaika',
32 => 'hogeita hamabi',
33 => 'hogeita hamahiru',
34 => 'hogeita hamalau',
35 => 'hogeita hamabost',
36 => 'hogeita hamasei',
37 => 'hogeita hamazazpi',
38 => 'hogeita hemezortzi',
39 => 'hogeita hemeretzi',
40 => 'berrogei',
41 => 'berrogeita bat',
42 => 'berrogeita bi',
43 => 'berrogeita hiru',
44 => 'berrogeita lau',
45 => 'berrogeita bost',
46 => 'berrogeita sei',
47 => 'berrogeita zazpi',
48 => 'berrogeita zortzi',
49 => 'berrogeita bederatzi',
50 => 'berrogeita hamar',
51 => 'berrogeita hamaika',
52 => 'berrogeita hamabi',
53 => 'berrogeita hamahiru',
54 => 'berrogeita hamalau',
55 => 'berrogeita hamabost',
56 => 'berrogeita hamasei',
57 => 'berrogeita hamazazpi',
58 => 'berrogeita hemezortzi',
59 => 'berrogeita hemeretzi',
60 => 'hirurogei',
61 => 'hirurogeita bat',
62 => 'hirurogeita bi',
63 => 'hirurogeita hiru',
64 => 'hirurogeita lau',
65 => 'hirurogeita bost',
66 => 'hirurogeita sei',
67 => 'hirurogeita zazpi',
68 => 'hirurogeita zortzi',
69 => 'hirurogeita bederatzi',
70 => 'hirurogeita hamar',
71 => 'hirurogeita hamaika',
72 => 'hirurogeita hamabi',
73 => 'hirurogeita hamahiru',
74 => 'hirurogeita hamalau',
75 => 'hirurogeita hamabost',
76 => 'hirurogeita hamasei',
77 => 'hirurogeita hamazazpi',
78 => 'hirurogeita hemezortzi',
79 => 'hirurogeita hemeretzi',
80 => 'laurogei',
81 => 'laurogeita bat',
82 => 'laurogeita bi',
83 => 'laurogeita hiru',
84 => 'laurogeita lau',
85 => 'laurogeita bost',
86 => 'laurogeita sei',
87 => 'laurogeita zazpi',
88 => 'laurogeita zortzi',
89 => 'laurogeita bederatzi',
90 => 'laurogeita hamar',
91 => 'laurogeita hamaika',
92 => 'laurogeita hamabi',
93 => 'laurogeita hamahiru',
94 => 'laurogeita hamalau',
95 => 'laurogeita hamabost',
96 => 'laurogeita hamasei',
97 => 'laurogeita hamazazpi',
98 => 'laurogeita hemezortzi',
99 => 'laurogeita hemeretzi',
100 => 'ehun',
101 => 'ehun eta bat',
102 => 'ehun eta bi',
110 => 'ehun eta hamar',
200 => 'berrehun',
202 => 'berrehun eta bi',
210 => 'berrehun eta hamar',
300 => 'hirurehun',
400 => 'laurehun',
500 => 'bostehun',
600 => 'seiehun',
700 => 'zazpiehun',
800 => 'zortziehun',
900 => 'bederatziehun',
1_000 => 'mila',
1_001 => 'mila eta bat',
1_010 => 'mila hamar',
1_100 => 'mila eta ehun',
1_200 => 'mila eta berrehun',
1_201 => 'mila berrehun eta bat',
1_984 => 'mila bederatziehun eta laurogeita lau',
1_000_000 => 'milioi bat',
1_000_001 => 'milioi bat eta bat',
1_000_002 => 'milioi bat eta bi',
1_000_010 => 'milioi bat eta hamar',
1_000_100 => 'milioi bat eta ehun',
1_000_200 => 'milioi bat eta berrehun',
1_001_000 => 'milioi bat eta mila',
1_002_000 => 'milioi bat eta bi mila',
1_001_100 => 'milioi bat eta mila eta ehun',
1_002_200 => 'milioi bat eta bi mila eta berrehun',
1_001_101 => 'milioi bat eta mila ehun eta bat',
1_001_102 => 'milioi bat eta mila ehun eta bi',
1_010_000 => 'milioi bat eta hamar mila',
1_020_000 => 'milioi bat eta hogei mila',
1_010_100 => 'milioi bat eta hamar mila eta ehun',
1_010_200 => 'milioi bat eta hamar mila eta berrehun',
1_010_101 => 'milioi bat eta hamar mila ehun eta bat',
10_000_000 => 'hamar milioi',
20_000_000 => 'hogei milioi',
10_000_001 => 'hamar milioi eta bat',
20_000_001 => 'hogei milioi eta bat',
20_000_002 => 'hogei milioi eta bi',
20_000_200 => 'hogei milioi eta berrehun',
1_000_000_000 => 'mila milioi',
1_000_000_001 => 'mila milioi eta bat',
2_000_000_000 => 'bi mila milioi',
2_000_000_001 => 'bi mila milioi eta bat',
10_000_000_000 => 'hamar mila milioi',
20_000_000_000 => 'hogei mila milioi',
100_000_000_000 => 'ehun mila milioi',
200_000_000_000 => 'berrehun mila milioi',
101_000_000_000 => 'ehun eta bat mila milioi',
201_000_000_000 => 'berrehun eta bat mila milioi',
110_000_000_000 => 'ehun eta hamar mila milioi',
210_000_000_000 => 'berrehun eta hamar mila milioi'

) ;


while( my( $key, $value) = each(%list) ) {
   my $result = &cardinal2alpha($key) ;
   is($result, $value, "Value of $key") ;
}
