package Bencher::Scenario::TextANSIUtil::Wrap;

our $DATE = '2016-03-13'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

our $scenario = {
    summary => 'Benchmark text wrapping',
    modules => {
        'Text::ANSI::Util' => {version => 0.22},
    },
    participants => [
        {fcall_template => 'Text::ANSI::Util::ta_wrap(<text>, <width>)'},
        {fcall_template => 'Text::ANSI::WideUtil::ta_mbwrap(<text>, <width>)'},
        {code_template  => 'local $Text::Wrap::columns = <width>; Text::Wrap::wrap("", "", <text>)', module=>'Text::Wrap'},
    ],
    datasets => [
        {name=>'ascii-100c-nocolor', tags=>['ascii'], args=>{text=>'foobar bz ' x 10, width=>77}},
    ],
};

1;
# ABSTRACT: Benchmark text wrapping

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::TextANSIUtil::Wrap - Benchmark text wrapping

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::TextANSIUtil::Wrap (from Perl distribution Bencher-Scenarios-TextANSIUtil), released on 2016-03-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m TextANSIUtil::Wrap

To run module startup overhead benchmark:

 % bencher --module-startup -m TextANSIUtil::Wrap

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Text::ANSI::Util> 0.22

L<Text::ANSI::WideUtil> 0.22

L<Text::Wrap> 2013.0523

=head1 BENCHMARK PARTICIPANTS

=over

=item * Text::ANSI::Util::ta_wrap (perl_code)

Function call template:

 Text::ANSI::Util::ta_wrap(<text>, <width>)



=item * Text::ANSI::WideUtil::ta_mbwrap (perl_code)

Function call template:

 Text::ANSI::WideUtil::ta_mbwrap(<text>, <width>)



=item * Text::Wrap (perl_code)

Code template:

 local $Text::Wrap::columns = <width>; Text::Wrap::wrap("", "", <text>)



=back

=head1 BENCHMARK DATASETS

=over

=item * ascii-100c-nocolor [ascii]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m TextANSIUtil::Wrap >>):

 +---------------------------------+-----------+-----------+------------+---------+---------+
 | participant                     | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +---------------------------------+-----------+-----------+------------+---------+---------+
 | Text::ANSI::WideUtil::ta_mbwrap | 4.8e+03   | 210       | 1          | 2.1e-07 | 20      |
 | Text::ANSI::Util::ta_wrap       | 7.8e+03   | 130       | 1.6        | 2.1e-07 | 20      |
 | Text::Wrap                      | 3.62e+04  | 27.6      | 7.49       | 1.3e-08 | 20      |
 +---------------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m TextANSIUtil::Wrap --module-startup >>):

 +----------------------+-----------+------------------------+------------+---------+---------+
 | participant          | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +----------------------+-----------+------------------------+------------+---------+---------+
 | Text::ANSI::WideUtil | 27        | 24.7                   | 1          | 6.7e-05 | 20      |
 | Text::ANSI::Util     | 6.8       | 4.5                    | 4          | 9.1e-06 | 20      |
 | Text::Wrap           | 6.8       | 4.5                    | 4          | 1.6e-05 | 20      |
 | perl -e1 (baseline)  | 2.3       | 0                      | 12         | 5.5e-06 | 20      |
 +----------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-TextANSIUtil>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-TextANSIUtil>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-TextANSIUtil>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
