package Bencher::Scenario::TextANSIUtil::Startup;

our $DATE = '2016-03-13'; # DATE
our $VERSION = '0.01'; # VERSION

our $scenario = {
    summary => 'Benchmark startup overhead of Text::ANSI::{Util,WideUtil}',
    module_startup => 1,
    modules => {
        'Text::ANSI::Util' => {version => 0.22},
    },
    participants => [
        {module => 'Text::ANSI::Util'},
        {module => 'Text::ANSI::WideUtil'},
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of Text::ANSI::{Util,WideUtil}

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::TextANSIUtil::Startup - Benchmark startup overhead of Text::ANSI::{Util,WideUtil}

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::TextANSIUtil::Startup (from Perl distribution Bencher-Scenarios-TextANSIUtil), released on 2016-03-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m TextANSIUtil::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Text::ANSI::Util> 0.22

L<Text::ANSI::WideUtil> 0.22

=head1 BENCHMARK PARTICIPANTS

=over

=item * Text::ANSI::Util (perl_code)

L<Text::ANSI::Util>



=item * Text::ANSI::WideUtil (perl_code)

L<Text::ANSI::WideUtil>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m TextANSIUtil::Startup >>):

 +----------------------+-----------+------------------------+------------+---------+---------+
 | participant          | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +----------------------+-----------+------------------------+------------+---------+---------+
 | Text::ANSI::WideUtil | 28        | 25.6                   | 1          | 9.3e-05 | 20      |
 | Text::ANSI::Util     | 6.7       | 4.3                    | 4.1        | 2.3e-05 | 22      |
 | perl -e1 (baseline)  | 2.4       | 0                      | 12         | 1.1e-05 | 20      |
 +----------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-TextANSIUtil>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-TextANSIUtil>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-TextANSIUtil>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
