package Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic;

our $DATE = '2016-06-18'; # DATE
our $VERSION = '0.003'; # VERSION

our $scenario = {
    summary => 'Benchmark parse_arithmetic()',
    modules => {
    },
    participants => [
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::parse_arithmetic(<expr>)',
        },
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic(<expr>)',
        },
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic(<expr>)',
        },
    ],
    datasets => [
        {
            args => {expr => '1'},
        },
        {
            args => {expr => '1' . ('+1' x (  2-1)) },
        },
        {
            args => {expr => '1' . ('+1' x (  5-1)) },
        },
        {
            name => '1+1+..+1 (10x)',
            args => {expr => '1' . ('+1' x ( 10-1)) } },
        {
            name => '1+1+..+1 (20x)',
            args => {expr => '1' . ('+1' x ( 20-1)) },
        },
        {
            name => '1+1+..+1 (100x)',
            args => {expr => '1' . ('+1' x (100-1)) },
        },
    ],
};

1;
# ABSTRACT: Benchmark parse_arithmetic()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic - Benchmark parse_arithmetic()

=head1 VERSION

This document describes version 0.003 of Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic (from Perl distribution Bencher-Scenarios-PERLANCARParseArithmetic), released on 2016-06-18.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCARParseArithmetic::parse_arithmetic

To run module startup overhead benchmark:

 % bencher --module-startup -m PERLANCARParseArithmetic::parse_arithmetic

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<PERLANCAR::Parse::Arithmetic>

L<PERLANCAR::Parse::Arithmetic::Marpa>

L<PERLANCAR::Parse::Arithmetic::NoHash>

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Parse::Arithmetic::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::parse_arithmetic(<expr>)



=item * PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic(<expr>)



=item * PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic(<expr>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 1

=item * 1+1

=item * 1+1+1+1+1

=item * 1+1+..+1 (10x)

=item * 1+1+..+1 (20x)

=item * 1+1+..+1 (100x)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCARParseArithmetic::parse_arithmetic >>):

 +--------------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+
 | participant                                            | dataset         | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +--------------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (100x) |    848    |  1180     |    1       | 6.2e-07 |      21 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (20x)  |   2010    |   498     |    2.37    | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (10x)  |   2440    |   409     |    2.88    | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+1+1+1       |   2750    |   363     |    3.24    | 1.6e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1             |   3040    |   329     |    3.59    | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1               |   3270    |   305     |    3.86    | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (100x) |   3500    |   286     |    4.12    | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (100x) |   3727.73 |   268.26  |    4.39402 | 3.5e-11 |      22 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (20x)  |  17300    |    57.7   |   20.4     | 2.2e-08 |      29 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (20x)  |  19000    |    54     |   22       | 1.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (10x)  |  34900    |    28.7   |   41.1     | 1.1e-08 |      28 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (10x)  |  37300    |    26.8   |   43.9     | 1.3e-08 |      22 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+1+1+1       |  66959    |    14.935 |   78.927   | 4.6e-11 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+1+1+1       |  71500    |    14     |   84.3     | 5.1e-09 |      34 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1             | 158000    |     6.34  |  186       | 3.2e-09 |      22 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1             | 170000    |     6     |  200       | 6.7e-09 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1               | 290000    |     3.4   |  340       | 5.5e-09 |      29 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1               | 300000    |     3.3   |  360       | 6.5e-09 |      21 |
 +--------------------------------------------------------+-----------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PERLANCARParseArithmetic::parse_arithmetic --module-startup >>):

 +--------------------------------------+-----------+------------------------+------------+-----------+---------+
 | participant                          | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +--------------------------------------+-----------+------------------------+------------+-----------+---------+
 | PERLANCAR::Parse::Arithmetic::Marpa  | 55        |                   52.5 | 1          |   0.00011 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash | 4.6       |                    2.1 | 12         | 1.8e-05   |      22 |
 | PERLANCAR::Parse::Arithmetic         | 4.6       |                    2.1 | 12         | 8.1e-06   |      20 |
 | perl -e1 (baseline)                  | 2.5       |                    0   | 22         | 2.9e-06   |      20 |
 +--------------------------------------+-----------+------------------------+------------+-----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCARParseArithmetic>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCARParseArithmetic>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCARParseArithmetic>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
