package Bencher::Scenario::PERLANCAR::pass_list_vs_array;

our $DATE = '2016-04-13'; # DATE
our $VERSION = '0.04'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark passing list vs array reference',
    description => <<'_',


_
    participants => [
        {
            name=>'pass_list',
            code_template=>'my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(@list) }',
        },
        {
            name=>'pass_arrayref',
            code_template=>'my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(\@list) }',
        },
    ],

    datasets => [
        {name => 'data', args => {'size@'=>[100, 1000, 10000], 'reuse@'=>[1, 10, 100, 1000]}},
    ],
};

1;
# ABSTRACT: Benchmark passing list vs array reference

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCAR::pass_list_vs_array - Benchmark passing list vs array reference

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::PERLANCAR::pass_list_vs_array (from Perl distribution Bencher-Scenarios-PERLANCAR), released on 2016-04-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCAR::pass_list_vs_array

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * pass_list (perl_code)

Code template:

 my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(@list) }



=item * pass_arrayref (perl_code)

Code template:

 my $sub = sub {}; my @list = 1..<size>;  for (1..<reuse>) { $sub->(\@list) }



=back

=head1 BENCHMARK DATASETS

=over

=item * data

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCAR::pass_list_vs_array >>):

 +---------------+-----------+----------+------------+-----------+------------+---------+---------+
 | participant   | arg_reuse | arg_size | rate (/s)  | time (ms) | vs_slowest | errors  | samples |
 +---------------+-----------+----------+------------+-----------+------------+---------+---------+
 | pass_list     | 1000      | 10000    | 50.2       | 19.9      | 1          | 1.6e-05 | 20      |
 | pass_list     | 100       | 10000    | 475        | 2.11      | 9.46       | 2.1e-07 | 20      |
 | pass_list     | 1000      | 1000     | 5.9e+02    | 1.7       | 12         | 1.8e-06 | 21      |
 | pass_list     | 10        | 10000    | 2.64e+03   | 0.379     | 52.6       | 4e-08   | 36      |
 | pass_arrayref | 1000      | 10000    | 3558.64    | 0.281006  | 70.9054    | 4.6e-11 | 20      |
 | pass_list     | 1000      | 100      | 4.4e+03    | 0.227     | 87.6       | 2.1e-07 | 20      |
 | pass_list     | 1         | 10000    | 4.91e+03   | 0.204     | 97.9       | 1.4e-07 | 25      |
 | pass_arrayref | 100       | 10000    | 5.16e+03   | 0.194     | 103        | 5.3e-08 | 20      |
 | pass_list     | 100       | 1000     | 5350.74    | 0.18689   | 106.613    | 3.3e-11 | 20      |
 | pass_arrayref | 10        | 10000    | 5406.96    | 0.184947  | 107.733    | 4.6e-11 | 20      |
 | pass_arrayref | 1         | 10000    | 5436.88    | 0.183929  | 108.3289   | 1.1e-11 | 26      |
 | pass_arrayref | 1000      | 1000     | 8551.333   | 0.1169408 | 170.3838   | 1.1e-11 | 21      |
 | pass_arrayref | 1000      | 100      | 1e+04      | 0.0999    | 199        | 2.7e-08 | 20      |
 | pass_list     | 10        | 1000     | 28204.5    | 0.0354554 | 561.969    | 9.6e-12 | 20      |
 | pass_arrayref | 100       | 1000     | 34873      | 0.028675  | 694.84     | 4.6e-11 | 20      |
 | pass_list     | 100       | 100      | 3.5e+04    | 0.028     | 7e+02      | 4.8e-08 | 38      |
 | pass_list     | 1         | 1000     | 4.8e+04    | 0.021     | 9.5e+02    | 2.5e-08 | 23      |
 | pass_arrayref | 10        | 1000     | 50475      | 0.019812  | 1005.7     | 3.5e-11 | 20      |
 | pass_arrayref | 1         | 1000     | 52839      | 0.018926  | 1052.8     | 4.5e-11 | 20      |
 | pass_arrayref | 100       | 100      | 83826      | 0.01193   | 1670.2     | 3.5e-11 | 20      |
 | pass_list     | 10        | 100      | 2.26e+05   | 0.00442   | 4.51e+03   | 1.4e-09 | 28      |
 | pass_arrayref | 10        | 100      | 3.1718e+05 | 0.0031528 | 6319.7     | 1.1e-11 | 20      |
 | pass_list     | 1         | 100      | 4.192e+05  | 0.002385  | 8353       | 4.6e-11 | 20      |
 | pass_arrayref | 1         | 100      | 4.4201e+05 | 0.0022624 | 8807       | 1.1e-11 | 20      |
 +---------------+-----------+----------+------------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Passing a large array by reference will generate a large saving only if we reuse
the list (pass it multiple times).

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
