package Bencher::Scenario::LogGer::Startup;

our $DATE = '2017-06-29'; # DATE
our $VERSION = '0.007'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Measure startup overhead of Log::ger vs other logging libraries',
    modules => {
        'Log::ger' => {version=>'0.010'},
    },
    participants => [
        {name=>"baseline", perl_cmdline => ["-e1"]},

        {name=>"use Log::ger ()", module=>'Log::ger', perl_cmdline => ["-mLog::ger", "-e1"]},

        {name=>"use Log::ger" , module=>'Log::ger', perl_cmdline => ["-MLog::ger", "-e1"]},
        {name=>"use Log::ger + use LGP:OptAway", module=>'Log::ger::Plugin::OptAway', perl_cmdline => ["-MLog::ger::Plugin::OptAway", "-MLog::ger", "-e1"]},
        {name=>"use Log::ger + use LGP:Screen", module=>'Log::ger::Output::Screen', perl_cmdline => ["-MLog::ger", "-MLog::ger::Output=Screen", "-e1"]},
        {name=>"use Log::ger::Like::LogAny" , module=>'Log::ger::Like::LogAny', perl_cmdline => ["-MLog::ger::Like::LogAny", "-e1"]},

        {name=>"use Log::Any" , module=>'Log::Any', perl_cmdline => ["-MLog::Any", "-e1"]},
        {name=>"use Log::Any + use LGA:Screen" , module=>'Log::Any::Adapter::Screen', perl_cmdline => ["-MLog::Any", "-MLog::Any::Adapter=Screen", "-e1"]},

        {name=>"use Log::Log4perl ()", module=>'Log::Log4perl', perl_cmdline => ["-mLog::Log4perl", '-e1']},
        {name=>"use Log::Log4perl + easy_init", module=>'Log::Log4perl', perl_cmdline => ["-MLog::Log4perl=:easy", '-e', 'Log::Log4perl->easy_init']},

        {name=>"use Log::Log4perl::Tiny ()", module=>'Log::Log4perl::Tiny', perl_cmdline => ["-mLog::Log4perl::Tiny", '-e1']},
        {name=>"use Log::Log4perl::Tiny :easy", module=>'Log::Log4perl::Tiny', perl_cmdline => ["-MLog::Log4perl::Tiny=:easy", '-e', 'Log::Log4perl->easy_init']},
    ],
};

1;
# ABSTRACT: Measure startup overhead of Log::ger vs other logging libraries

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LogGer::Startup - Measure startup overhead of Log::ger vs other logging libraries

=head1 VERSION

This document describes version 0.007 of Bencher::Scenario::LogGer::Startup (from Perl distribution Bencher-Scenarios-LogGer), released on 2017-06-29.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LogGer::Startup

To run module startup overhead benchmark:

 % bencher --module-startup -m LogGer::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Log::Any> 1.045

L<Log::Any::Adapter::Screen> 0.13

L<Log::Log4perl> 1.47

L<Log::Log4perl::Tiny> 1.4.0

L<Log::ger> 0.010

L<Log::ger::Like::LogAny> 0.001

L<Log::ger::Output::Screen> 0.004

L<Log::ger::Plugin::OptAway> 0.003

=head1 BENCHMARK PARTICIPANTS

=over

=item * baseline (command)



=item * use Log::ger () (command)

L<Log::ger>



=item * use Log::ger (command)

L<Log::ger>



=item * use Log::ger + use LGP:OptAway (command)

L<Log::ger::Plugin::OptAway>



=item * use Log::ger + use LGP:Screen (command)

L<Log::ger::Output::Screen>



=item * use Log::ger::Like::LogAny (command)

L<Log::ger::Like::LogAny>



=item * use Log::Any (command)

L<Log::Any>



=item * use Log::Any + use LGA:Screen (command)

L<Log::Any::Adapter::Screen>



=item * use Log::Log4perl () (command)

L<Log::Log4perl>



=item * use Log::Log4perl + easy_init (command)

L<Log::Log4perl>



=item * use Log::Log4perl::Tiny () (command)

L<Log::Log4perl::Tiny>



=item * use Log::Log4perl::Tiny :easy (command)

L<Log::Log4perl::Tiny>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.5 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with C<< bencher -m LogGer::Startup --include-path archive/Log-Any-0.15/lib --multimodver Log::Any >>:

 #table1#
 +--------------------------------+--------+-----------+-----------+------------+----------+---------+
 | participant                    | modver | rate (/s) | time (ms) | vs_slowest |  errors  | samples |
 +--------------------------------+--------+-----------+-----------+------------+----------+---------+
 | use Log::Log4perl + easy_init  |        |        41 |      24   |        1   |   0.0001 |      20 |
 | use Log::Log4perl ()           |        |        42 |      24   |        1   | 5.1e-05  |      20 |
 | use Log::Log4perl::Tiny ()     |        |        86 |      12   |        2.1 | 5.3e-05  |      20 |
 | use Log::Log4perl::Tiny :easy  |        |        87 |      11   |        2.1 | 3.2e-05  |      20 |
 | use Log::Any + use LGA:Screen  |        |       120 |       8.4 |        2.9 | 4.6e-05  |      20 |
 | use Log::Any                   | 1.045  |       140 |       7   |        3.5 | 2.2e-05  |      22 |
 | use Log::ger + use LGP:Screen  |        |       180 |       5.4 |        4.5 | 2.8e-05  |      21 |
 | use Log::ger::Like::LogAny     |        |       220 |       4.6 |        5.3 | 1.9e-05  |      20 |
 | use Log::ger + use LGP:OptAway |        |       270 |       3.7 |        6.6 | 2.4e-05  |      20 |
 | use Log::Any                   | 0.15   |       330 |       3.1 |        7.9 | 1.8e-05  |      20 |
 | use Log::ger                   |        |       460 |       2.2 |       11   | 1.6e-05  |      21 |
 | use Log::ger ()                |        |       490 |       2   |       12   | 1.3e-05  |      20 |
 | baseline                       |        |       830 |       1.2 |       20   | 4.7e-06  |      20 |
 +--------------------------------+--------+-----------+-----------+------------+----------+---------+


Benchmark module startup overhead (C<< bencher -m LogGer::Startup --module-startup >>):

 #table2#
 +---------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+
 | participant               | proc_private_dirty_size (MB) | proc_rss_size (MB) | proc_size (MB) | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+
 | Log::Log4perl             | 1.7                          | 5                  | 21             |      27   |                   24.2 |        1   | 6.7e-05 |      21 |
 | Log::Log4perl::Tiny       | 4.4                          | 7.9                | 32             |      15   |                   12.2 |        1.8 | 2.3e-05 |      20 |
 | Log::Any::Adapter::Screen | 1.5                          | 4.9                | 21             |      11   |                    8.2 |        2.5 | 4.1e-05 |      20 |
 | Log::Any                  | 1.2                          | 4.5                | 20             |       9.1 |                    6.3 |        3   |   2e-05 |      20 |
 | Log::ger::Like::LogAny    | 0.86                         | 4.2                | 20             |       6.7 |                    3.9 |        4   | 2.7e-05 |      20 |
 | Log::ger::Output::Screen  | 0.83                         | 4.1                | 20             |       4.7 |                    1.9 |        5.7 | 3.1e-05 |      20 |
 | Log::ger::Plugin::OptAway | 1                            | 4.3                | 20             |       4.7 |                    1.9 |        5.7 |   2e-05 |      20 |
 | Log::ger                  | 1                            | 4.3                | 20             |       4   |                    1.2 |        6.8 | 1.2e-05 |      20 |
 | perl -e1 (baseline)       | 0.82                         | 4.1                | 20             |       2.8 |                    0   |        9.6 | 6.1e-06 |      21 |
 +---------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-LogGer>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-LogGer>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-LogGer>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
