package Bencher::Scenario::DateTimeFormatAlami::Parsing;

our $DATE = '2016-06-29'; # DATE
our $VERSION = '0.003'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark parsing speed of DateTime::Format::Alami against some other modules',
    modules => {
        'DateTime::Format::Alami::EN' => {version => 0.11},
        'DateTime::Format::Alami::ID' => {version => 0.11},
    },
    participants => [
        {
            module=>'DateTime::Format::Alami::EN',
            code_template => 'state $parser = DateTime::Format::Alami::EN->new; $parser->parse_datetime(<text>)',
            tags => ['lang:en'],
        },
        {
            module=>'DateTime::Format::Alami::ID',
            code_template => 'state $parser = DateTime::Format::Alami::ID->new; $parser->parse_datetime(<text>)',
            tags => ['lang:id'],
        },
        {
            module=>'Date::Extract',
            code_template => 'state $parser = Date::Extract->new; $parser->extract(<text>)',
            tags => ['lang:en'],
        },
        {
            module=>'DateTime::Format::Natural',
            code_template => 'state $parser = DateTime::Format::Natural->new; $parser->parse_datetime(<text>)',
            tags => ['lang:en'],
        },
        {
            module=>'DateTime::Format::Flexible',
            code_template => 'DateTime::Format::Flexible->parse_datetime(<text>)',
            tags => ['lang:en'],
        },
    ],
    datasets => [
        {args => {text => '18 feb'}},
        {args => {text => 'today'}, include_participant_tags => ['lang:en']},
        {args => {text => 'hari ini'}, include_participant_tags => ['lang:id']},
    ],
};

1;
# ABSTRACT: Benchmark parsing speed of DateTime::Format::Alami against some other modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DateTimeFormatAlami::Parsing - Benchmark parsing speed of DateTime::Format::Alami against some other modules

=head1 VERSION

This document describes version 0.003 of Bencher::Scenario::DateTimeFormatAlami::Parsing (from Perl distribution Bencher-Scenarios-DateTimeFormatAlami), released on 2016-06-29.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DateTimeFormatAlami::Parsing

To run module startup overhead benchmark:

 % bencher --module-startup -m DateTimeFormatAlami::Parsing

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Date::Extract> 0.05

L<DateTime::Format::Alami::EN> 0.11

L<DateTime::Format::Alami::ID> 0.11

L<DateTime::Format::Flexible> 0.26

L<DateTime::Format::Natural> 1.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * DateTime::Format::Alami::EN (perl_code) [lang:en]

Code template:

 state $parser = DateTime::Format::Alami::EN->new; $parser->parse_datetime(<text>)



=item * DateTime::Format::Alami::ID (perl_code) [lang:id]

Code template:

 state $parser = DateTime::Format::Alami::ID->new; $parser->parse_datetime(<text>)



=item * Date::Extract (perl_code) [lang:en]

Code template:

 state $parser = Date::Extract->new; $parser->extract(<text>)



=item * DateTime::Format::Natural (perl_code) [lang:en]

Code template:

 state $parser = DateTime::Format::Natural->new; $parser->parse_datetime(<text>)



=item * DateTime::Format::Flexible (perl_code) [lang:en]

Code template:

 DateTime::Format::Flexible->parse_datetime(<text>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 18 feb

=item * today

=item * hari ini

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DateTimeFormatAlami::Parsing >>):

 #table1#
 +-----------------------------+----------+-----------+-----------+------------+---------+---------+
 | participant                 | dataset  | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------------------------+----------+-----------+-----------+------------+---------+---------+
 | DateTime::Format::Flexible  | today    |       350 |     2.9   |       1    | 2.1e-05 |      20 |
 | DateTime::Format::Flexible  | 18 feb   |       350 |     2.8   |       1    | 2.4e-05 |      21 |
 | Date::Extract               | 18 feb   |       679 |     1.47  |       1.94 | 7.5e-07 |      20 |
 | Date::Extract               | today    |       926 |     1.08  |       2.65 | 6.2e-07 |      21 |
 | DateTime::Format::Natural   | 18 feb   |      1210 |     0.825 |       3.47 | 6.4e-07 |      20 |
 | DateTime::Format::Alami::EN | 18 feb   |      1300 |     0.77  |       3.7  | 2.5e-06 |      20 |
 | DateTime::Format::Alami::ID | 18 feb   |      1300 |     0.768 |       3.73 | 6.2e-07 |      21 |
 | DateTime::Format::Natural   | today    |      2300 |     0.44  |       6.5  | 4.8e-07 |      20 |
 | DateTime::Format::Alami::EN | today    |      3500 |     0.29  |      10    |   6e-07 |      23 |
 | DateTime::Format::Alami::ID | hari ini |     22000 |     0.045 |      64    | 6.7e-08 |      20 |
 +-----------------------------+----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DateTimeFormatAlami::Parsing --module-startup >>):

 #table1#
 +-----------------------------+-----------+------------------------+------------+-----------+---------+
 | participant                 | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +-----------------------------+-----------+------------------------+------------+-----------+---------+
 | DateTime::Format::Flexible  |     110   |                  105.4 |        1   |   0.00015 |      20 |
 | Date::Extract               |      90   |                   85.4 |        1   |   0.0012  |      21 |
 | DateTime::Format::Natural   |      85   |                   80.4 |        1.3 |   0.00066 |      20 |
 | DateTime::Format::Alami::ID |      23   |                   18.4 |        4.9 | 5.8e-05   |      21 |
 | DateTime::Format::Alami::EN |      22   |                   17.4 |        5   | 4.8e-05   |      20 |
 | perl -e1 (baseline)         |       4.6 |                    0   |       24   | 3.5e-05   |      21 |
 +-----------------------------+-----------+------------------------+------------+-----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DateTimeFormatAlami>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DateTimeFormatAlami>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DateTimeFormatAlami>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
