package Bencher::Scenario::DataSah::normalize_schema;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

# TODO: benchmark normalize_clset

our $scenario = {
    summary => 'Benchmark normalizing Sah schema',
    participants => [
        {
            fcall_template => 'Data::Sah::Normalize::normalize_schema(<schema>)'
        },
    ],
    datasets => [

        {
            name    => 'str',
            summary => '',
            args    => {
                schema => 'str',
            },
        },

        {
            name => 'str_wildcard',
            args => {
                schema => 'str*',
            },
        },

        {
            name => 'array1',
            args => {
                schema => ['str'],
            },
        },

        {
            name => 'array3',
            args => {
                schema => ['str', len=>1],
            },
        },

        {
            name => 'array5',
            args => {
                schema => ['str', min_len=>8, max_len=>16],
            },
        },

    ],
};

1;
# ABSTRACT: Benchmark normalizing Sah schema

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::normalize_schema

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::DataSah::normalize_schema (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::normalize_schema

To run module startup overhead benchmark:

 % bencher --module-startup -m DataSah::normalize_schema

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Data::Sah::Normalize> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::Sah::Normalize::normalize_schema (perl_code)

Function call template:

 Data::Sah::Normalize::normalize_schema(<schema>)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------------------------------------------------------------------+-----------+---------+---------+---------+
 | seq | name                                                                            | rate      | time    | errors  | samples |
 +-----+---------------------------------------------------------------------------------+-----------+---------+---------+---------+
 | 4   | {dataset=>"array5",participant=>"Data::Sah::Normalize::normalize_schema"}       | 7.1e+04   | 14μs    | 8.1e-08 | 23      |
 | 3   | {dataset=>"array3",participant=>"Data::Sah::Normalize::normalize_schema"}       | 9.377e+04 | 10.66μs | 3.3e-09 | 20      |
 | 2   | {dataset=>"array1",participant=>"Data::Sah::Normalize::normalize_schema"}       | 1.85e+05  | 5.42μs  | 7.8e-09 | 23      |
 | 1   | {dataset=>"str_wildcard",participant=>"Data::Sah::Normalize::normalize_schema"} | 3.11e+05  | 3.22μs  | 5e-09   | 20      |
 | 0   | {dataset=>"str",participant=>"Data::Sah::Normalize::normalize_schema"}          | 4.4e+05   | 2.3μs   | 1e-08   | 20      |
 +-----+---------------------------------------------------------------------------------+-----------+---------+---------+---------+


Benchmark module startup overhead:

 +-----+----------------------+--------+-------------------+---------+---------+
 | seq | name                 | time   | mod_overhead_time | errors  | samples |
 +-----+----------------------+--------+-------------------+---------+---------+
 | 1   | Data::Sah::Normalize | 8.32ms | 4.01ms            | 2.2e-05 | 20      |
 | 0   | perl -e1 (baseline)  | 4.3ms  | 0ms               | 1.5e-05 | 20      |
 +-----+----------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
