package Bencher::Scenario::PERLANCARTreeExamples;

our $DATE = '2016-03-26'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark PERLANCAR::Tree::Examples',
    description => <<'_',

Created just for testing, while adding feature in `Bencher` to return result
size.

_
    participants => [
        {
            fcall_template => 'PERLANCAR::Tree::Examples::gen_sample_tree(size => <size>, backend => <backend>)',
        },
    ],
    datasets => [
        {name => 'dataset', args=>{'size@'=>['tiny1', 'medium1'], 'backend@'=>['hash', 'array']}},
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark PERLANCAR::Tree::Examples

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCARTreeExamples - Benchmark PERLANCAR::Tree::Examples

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::PERLANCARTreeExamples (from Perl distribution Bencher-Scenario-PERLANCARTreeExamples), released on 2016-03-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCARTreeExamples

To run module startup overhead benchmark:

 % bencher --module-startup -m PERLANCARTreeExamples

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<PERLANCAR::Tree::Examples> 0.01

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Tree::Examples::gen_sample_tree (perl_code)

Function call template:

 PERLANCAR::Tree::Examples::gen_sample_tree(size => <size>, backend => <backend>)



=back

=head1 BENCHMARK DATASETS

=over

=item * dataset

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCARTreeExamples >>):

 +-------------+----------+-----------+-----------+------------+------------------+---------+---------+
 | arg_backend | arg_size | rate (/s) | time (ms) | vs_slowest | result_size (MB) | errors  | samples |
 +-------------+----------+-----------+-----------+------------+------------------+---------+---------+
 | array       | medium1  | 15.6      | 64.3      | 1          | 3.74             | 2.5e-05 | 20      |
 | hash        | medium1  | 18        | 55.6      | 1.16       | 8.18             | 4.4e-05 | 20      |
 | array       | tiny1    | 6.1e+04   | 0.016     | 3.9e+03    | 0.00052          | 2.5e-08 | 23      |
 | hash        | tiny1    | 6.5e+04   | 0.015     | 4.2e+03    | 0.0013           | 2.7e-08 | 20      |
 +-------------+----------+-----------+-----------+------------+------------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PERLANCARTreeExamples --module-startup >>):

 +---------------------------+-----------+------------------------+------------+-----------------+---------+---------+
 | participant               | time (ms) | mod_overhead_time (ms) | vs_slowest | result_size (b) | errors  | samples |
 +---------------------------+-----------+------------------------+------------+-----------------+---------+---------+
 | PERLANCAR::Tree::Examples | 18        | 10.8                   | 1          | 72              | 2.3e-05 | 20      |
 | perl -e1 (baseline)       | 7.2       | 0                      | 2.4        | 72              | 1.7e-05 | 20      |
 +---------------------------+-----------+------------------------+------------+-----------------+---------+---------+

=head1 DESCRIPTION

Created just for testing, while adding feature in C<Bencher> to return result
size.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-PERLANCARTreeExamples>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-PERLANCARTreeExamples>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-PERLANCARTreeExamples>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
