package Bencher::Scenario::MathPrimeModules;

our $DATE = '2016-09-23'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark modules that find prime numbers',
    modules => {
    },
    participants => [
        {
            fcall_template => 'Acme::PERLANCAR::Prime::primes(<num>)',
            result_is_list => 1,
        },
        {
            fcall_template => 'Math::Prime::Util::primes(<num>)',
        },
        # still can't get it to work
        #{
        #    module => 'Math::Prime::FastSieve',
        #    function => 'primes',
        #    code_template => 'use Math::Prime::FastSieve; my $sieve = Math::Prime::FastSieve::Sieve->new(<num>); $sieve->primes(<num>)',
        #},
        {
            fcall_template => 'Math::Prime::XS::primes(<num>)',
            result_is_list => 1,
        },
    ],

    precision => 6,

    datasets => [
        # just for testing correctness
        {args=>{num=>100}, result=>[2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97]},

        {args=>{num=>1000_000}},
    ],
};

1;
# ABSTRACT: Benchmark modules that find prime numbers

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::MathPrimeModules - Benchmark modules that find prime numbers

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::MathPrimeModules (from Perl distribution Bencher-Scenario-MathPrimeModules), released on 2016-09-23.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m MathPrimeModules

To run module startup overhead benchmark:

 % bencher --module-startup -m MathPrimeModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Acme::PERLANCAR::Prime> 0.001

L<Math::Prime::Util> 0.59

L<Math::Prime::XS> 0.27

=head1 BENCHMARK PARTICIPANTS

=over

=item * Acme::PERLANCAR::Prime::primes (perl_code)

Function call template:

 Acme::PERLANCAR::Prime::primes(<num>)



=item * Math::Prime::Util::primes (perl_code)

Function call template:

 Math::Prime::Util::primes(<num>)



=item * Math::Prime::XS::primes (perl_code)

Function call template:

 Math::Prime::XS::primes(<num>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 100

=item * 1000000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.5 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with C<< bencher -m MathPrimeModules --exclude-dataset-names 100 >>:

 #table1#
 +--------------------------------+-----------+-----------+------------+---------+---------+
 | participant                    | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +--------------------------------+-----------+-----------+------------+---------+---------+
 | Acme::PERLANCAR::Prime::primes |        76 |     13.2  |       1    | 2.8e-06 |       6 |
 | Math::Prime::XS::primes        |       253 |      3.95 |       3.33 | 7.2e-07 |       7 |
 | Math::Prime::Util::primes      |       800 |      1.2  |      11    | 2.9e-06 |       6 |
 +--------------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m MathPrimeModules --module-startup >>):

 #table2#
 +------------------------+-----------+------------------------+------------+---------+---------+
 | participant            | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +------------------------+-----------+------------------------+------------+---------+---------+
 | Math::Prime::XS        |      15   |                   12.5 |        1   |   8e-05 |       7 |
 | Math::Prime::Util      |      11   |                    8.5 |        1.3 | 6.6e-05 |       6 |
 | Acme::PERLANCAR::Prime |       4.8 |                    2.3 |        3.1 | 2.2e-05 |       9 |
 | perl -e1 (baseline)    |       2.5 |                    0   |        6   | 7.1e-06 |       7 |
 +------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-MathPrimeModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-MathPrimeModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-MathPrimeModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<http://blogs.perl.org/users/dana_jacobsen/2014/08/a-comparison-of-memory-use-for-primality-modules.html>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
