package Bencher::Scenario::GetoptModules;

our $DATE = '2015-12-23'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark some popular Perl Getopt modules',

    module_startup => 1,

    participants => [
        {module=>'Getopt::Long', tags=>['getopt-long']},
        {module=>'Getopt::Long::Less', tags=>['getopt-long']},
        {module=>'Getopt::Long::EvenLess', tags=>['getopt-long']},
        {module=>'Getopt::Long::Complete', tags=>['getopt-long']},
        {module=>'Getopt::Long::Descriptive', tags=>['getopt-long']},
        {module=>'Getopt::Long::Subcommand', tags=>['getopt-long']},

        {module=>'Getopt::Std'},

        {module=>'MooseX::Getopt', tags=>['moox']},

        {module=>'Getopt::ArgvFile'},
        {module=>'Getopt::Lucid'},
        {module=>'Getopt::Panjang'},
        {module=>'Getopt::Std::Strict'},
    ],
};

1;
# ABSTRACT: Benchmark some popular Perl Getopt modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::GetoptModules

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::GetoptModules (from Perl distribution Bencher-Scenario-GetoptModules), released on 2015-12-23.

=head1 SYNOPSIS

=head1 BENCHMARKED MODULES

L<Getopt::Long>

L<Getopt::Long::Less>

L<Getopt::Long::EvenLess>

L<Getopt::Long::Complete>

L<Getopt::Long::Descriptive>

L<Getopt::Long::Subcommand>

L<Getopt::Std>

L<MooseX::Getopt>

L<Getopt::ArgvFile>

L<Getopt::Lucid>

L<Getopt::Panjang>

L<Getopt::Std::Strict>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-GetoptModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-StartupGetoptModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-GetoptModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
