/*
 *    reentr.inc
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *  !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by reentrl.pl from data in reentr.pl.
 */

#ifndef REENTRINC
#define REENTRINC

#ifdef USE_REENTRANT_API

/* The reentrant wrappers. */

#ifdef HAS_ASCTIME_R
#   undef asctime
#   if !defined(asctime) && ASCTIME_R_PROTO == REENTRANT_PROTO_B_SB
#       define asctime(a) asctime_r(a, PL_reentrant_buffer->_asctime_buffer)
#   endif
#   if !defined(asctime) && ASCTIME_R_PROTO == REENTRANT_PROTO_B_SBI
#       define asctime(a) asctime_r(a, PL_reentrant_buffer->_asctime_buffer, PL_reentrant_buffer->_asctime_size)
#   endif
#   if !defined(asctime) && ASCTIME_R_PROTO == REENTRANT_PROTO_I_SB
#       ifdef PERL_CORE
#           define asctime(a) (((PL_REENTRANT_RETINT = asctime_r(a, PL_reentrant_buffer->_asctime_buffer))) == 0 ? PL_reentrant_buffer->_asctime_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define asctime(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = asctime_r(a, PL_reentrant_buffer->_asctime_buffer))) == 0 ? PL_reentrant_buffer->_asctime_buffer : 0);})
#           else
#               define asctime(a) S_my_asctime(a)
                static char* S_my_asctime(const struct tm* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = asctime_r(a, PL_reentrant_buffer->_asctime_buffer))) == 0 ? PL_reentrant_buffer->_asctime_buffer : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(asctime) && ASCTIME_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define asctime(a) (((PL_REENTRANT_RETINT = asctime_r(a, PL_reentrant_buffer->_asctime_buffer, PL_reentrant_buffer->_asctime_size))) == 0 ? PL_reentrant_buffer->_asctime_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define asctime(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = asctime_r(a, PL_reentrant_buffer->_asctime_buffer, PL_reentrant_buffer->_asctime_size))) == 0 ? PL_reentrant_buffer->_asctime_buffer : 0);})
#           else
#               define asctime(a) S_my_asctime(a)
                static char* S_my_asctime(const struct tm* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = asctime_r(a, PL_reentrant_buffer->_asctime_buffer, PL_reentrant_buffer->_asctime_size))) == 0 ? PL_reentrant_buffer->_asctime_buffer : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_ASCTIME_R */

#ifdef HAS_CRYPT_R
#   undef crypt
#   if !defined(crypt) && CRYPT_R_PROTO == REENTRANT_PROTO_B_CCS
#       define crypt(a, b) crypt_r(a, b, PL_reentrant_buffer->_crypt_struct_buffer)
#   endif
#   if !defined(crypt) && CRYPT_R_PROTO == REENTRANT_PROTO_B_CCD
#       define crypt(a, b) crypt_r(a, b, &PL_reentrant_buffer->_crypt_data)
#   endif
#endif /* HAS_CRYPT_R */

#ifdef HAS_CTERMID_R
#   undef ctermid
#   if !defined(ctermid) && CTERMID_R_PROTO == REENTRANT_PROTO_B_B
#       define ctermid(a) ctermid_r(a)
#   endif
#endif /* HAS_CTERMID_R */

#ifdef HAS_CTIME_R
#   undef ctime
#   if !defined(ctime) && CTIME_R_PROTO == REENTRANT_PROTO_B_SB
#       define ctime(a) ctime_r(a, PL_reentrant_buffer->_ctime_buffer)
#   endif
#   if !defined(ctime) && CTIME_R_PROTO == REENTRANT_PROTO_B_SBI
#       define ctime(a) ctime_r(a, PL_reentrant_buffer->_ctime_buffer, PL_reentrant_buffer->_ctime_size)
#   endif
#   if !defined(ctime) && CTIME_R_PROTO == REENTRANT_PROTO_I_SB
#       ifdef PERL_CORE
#           define ctime(a) (((PL_REENTRANT_RETINT = ctime_r(a, PL_reentrant_buffer->_ctime_buffer))) == 0 ? PL_reentrant_buffer->_ctime_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define ctime(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = ctime_r(a, PL_reentrant_buffer->_ctime_buffer))) == 0 ? PL_reentrant_buffer->_ctime_buffer : 0);})
#           else
#               define ctime(a) S_my_ctime(a)
                static char* S_my_ctime(const time_t* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = ctime_r(a, PL_reentrant_buffer->_ctime_buffer))) == 0 ? PL_reentrant_buffer->_ctime_buffer : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(ctime) && CTIME_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define ctime(a) (((PL_REENTRANT_RETINT = ctime_r(a, PL_reentrant_buffer->_ctime_buffer, PL_reentrant_buffer->_ctime_size))) == 0 ? PL_reentrant_buffer->_ctime_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define ctime(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = ctime_r(a, PL_reentrant_buffer->_ctime_buffer, PL_reentrant_buffer->_ctime_size))) == 0 ? PL_reentrant_buffer->_ctime_buffer : 0);})
#           else
#               define ctime(a) S_my_ctime(a)
                static char* S_my_ctime(const time_t* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = ctime_r(a, PL_reentrant_buffer->_ctime_buffer, PL_reentrant_buffer->_ctime_size))) == 0 ? PL_reentrant_buffer->_ctime_buffer : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_CTIME_R */

#ifdef HAS_DRAND48_R
#   undef drand48
#   if !defined(drand48) && DRAND48_R_PROTO == REENTRANT_PROTO_I_ST
#       ifdef PERL_CORE
#           define drand48() (((PL_REENTRANT_RETINT = drand48_r(&PL_reentrant_buffer->_drand48_struct, &PL_reentrant_buffer->_drand48_double))) == 0 ? PL_reentrant_buffer->_drand48_double : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define drand48() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = drand48_r(&PL_reentrant_buffer->_drand48_struct, &PL_reentrant_buffer->_drand48_double))) == 0 ? PL_reentrant_buffer->_drand48_double : 0);})
#           else
#               define drand48() S_my_drand48()
                static double S_my_drand48() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = drand48_r(&PL_reentrant_buffer->_drand48_struct, &PL_reentrant_buffer->_drand48_double))) == 0 ? PL_reentrant_buffer->_drand48_double : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_DRAND48_R */

#ifdef HAS_ENDGRENT_R
#   undef endgrent
#   if !defined(endgrent) && ENDGRENT_R_PROTO == REENTRANT_PROTO_I_H
#       ifdef PERL_CORE
#           define endgrent() (((PL_REENTRANT_RETINT = endgrent_r(&PL_reentrant_buffer->_grent_fptr))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define endgrent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = endgrent_r(&PL_reentrant_buffer->_grent_fptr))) == 0 ? 1 : 0);})
#           else
#               define endgrent() S_my_endgrent()
                static void S_my_endgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = endgrent_r(&PL_reentrant_buffer->_grent_fptr))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(endgrent) && ENDGRENT_R_PROTO == REENTRANT_PROTO_V_H
#       define endgrent() endgrent_r(&PL_reentrant_buffer->_grent_fptr)
#   endif
#endif /* HAS_ENDGRENT_R */

#ifdef HAS_ENDHOSTENT_R
#   undef endhostent
#   if !defined(endhostent) && ENDHOSTENT_R_PROTO == REENTRANT_PROTO_I_D
#       ifdef PERL_CORE
#           define endhostent() (((PL_REENTRANT_RETINT = endhostent_r(&PL_reentrant_buffer->_hostent_data))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define endhostent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = endhostent_r(&PL_reentrant_buffer->_hostent_data))) == 0 ? 1 : 0);})
#           else
#               define endhostent() S_my_endhostent()
                static void S_my_endhostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = endhostent_r(&PL_reentrant_buffer->_hostent_data))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(endhostent) && ENDHOSTENT_R_PROTO == REENTRANT_PROTO_V_D
#       define endhostent() endhostent_r(&PL_reentrant_buffer->_hostent_data)
#   endif
#endif /* HAS_ENDHOSTENT_R */

#ifdef HAS_ENDNETENT_R
#   undef endnetent
#   if !defined(endnetent) && ENDNETENT_R_PROTO == REENTRANT_PROTO_I_D
#       ifdef PERL_CORE
#           define endnetent() (((PL_REENTRANT_RETINT = endnetent_r(&PL_reentrant_buffer->_netent_data))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define endnetent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = endnetent_r(&PL_reentrant_buffer->_netent_data))) == 0 ? 1 : 0);})
#           else
#               define endnetent() S_my_endnetent()
                static void S_my_endnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = endnetent_r(&PL_reentrant_buffer->_netent_data))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(endnetent) && ENDNETENT_R_PROTO == REENTRANT_PROTO_V_D
#       define endnetent() endnetent_r(&PL_reentrant_buffer->_netent_data)
#   endif
#endif /* HAS_ENDNETENT_R */

#ifdef HAS_ENDPROTOENT_R
#   undef endprotoent
#   if !defined(endprotoent) && ENDPROTOENT_R_PROTO == REENTRANT_PROTO_I_D
#       ifdef PERL_CORE
#           define endprotoent() (((PL_REENTRANT_RETINT = endprotoent_r(&PL_reentrant_buffer->_protoent_data))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define endprotoent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = endprotoent_r(&PL_reentrant_buffer->_protoent_data))) == 0 ? 1 : 0);})
#           else
#               define endprotoent() S_my_endprotoent()
                static void S_my_endprotoent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = endprotoent_r(&PL_reentrant_buffer->_protoent_data))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(endprotoent) && ENDPROTOENT_R_PROTO == REENTRANT_PROTO_V_D
#       define endprotoent() endprotoent_r(&PL_reentrant_buffer->_protoent_data)
#   endif
#endif /* HAS_ENDPROTOENT_R */

#ifdef HAS_ENDPWENT_R
#   undef endpwent
#   if !defined(endpwent) && ENDPWENT_R_PROTO == REENTRANT_PROTO_I_H
#       ifdef PERL_CORE
#           define endpwent() (((PL_REENTRANT_RETINT = endpwent_r(&PL_reentrant_buffer->_pwent_fptr))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define endpwent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = endpwent_r(&PL_reentrant_buffer->_pwent_fptr))) == 0 ? 1 : 0);})
#           else
#               define endpwent() S_my_endpwent()
                static void S_my_endpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = endpwent_r(&PL_reentrant_buffer->_pwent_fptr))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(endpwent) && ENDPWENT_R_PROTO == REENTRANT_PROTO_V_H
#       define endpwent() endpwent_r(&PL_reentrant_buffer->_pwent_fptr)
#   endif
#endif /* HAS_ENDPWENT_R */

#ifdef HAS_ENDSERVENT_R
#   undef endservent
#   if !defined(endservent) && ENDSERVENT_R_PROTO == REENTRANT_PROTO_I_D
#       ifdef PERL_CORE
#           define endservent() (((PL_REENTRANT_RETINT = endservent_r(&PL_reentrant_buffer->_servent_data))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define endservent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = endservent_r(&PL_reentrant_buffer->_servent_data))) == 0 ? 1 : 0);})
#           else
#               define endservent() S_my_endservent()
                static void S_my_endservent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = endservent_r(&PL_reentrant_buffer->_servent_data))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(endservent) && ENDSERVENT_R_PROTO == REENTRANT_PROTO_V_D
#       define endservent() endservent_r(&PL_reentrant_buffer->_servent_data)
#   endif
#endif /* HAS_ENDSERVENT_R */

#ifdef HAS_GETGRENT_R
#   undef getgrent
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_I_SBWR
#       ifdef PERL_CORE
#           define getgrent() (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() S_my_getgrent()
                static struct group* S_my_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_I_SBIR
#       ifdef PERL_CORE
#           define getgrent() (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() S_my_getgrent()
                static struct group* S_my_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_S_SBW
#       ifdef PERL_CORE
#           define getgrent() (getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; (getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() S_my_getgrent()
                static struct group* S_my_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       ifdef PERL_CORE
#           define getgrent() (getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; (getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() S_my_getgrent()
                static struct group* S_my_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getgrent() (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() S_my_getgrent()
                static struct group* S_my_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_I_SBIH
#       ifdef PERL_CORE
#           define getgrent() (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_fptr))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_fptr))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() S_my_getgrent()
                static struct group* S_my_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_fptr))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETGRENT_R */

#ifdef HAS_GETGRGID_R
#   undef getgrgid
#   if !defined(getgrgid) && GETGRGID_R_PROTO == REENTRANT_PROTO_I_TSBWR
#       ifdef PERL_CORE
#           define getgrgid(a) (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrgid(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0));})
#           else
#               define getgrgid(a) S_my_getgrgid(a)
                static struct group* S_my_getgrgid(gid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrgid) && GETGRGID_R_PROTO == REENTRANT_PROTO_I_TSBIR
#       ifdef PERL_CORE
#           define getgrgid(a) (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrgid(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0));})
#           else
#               define getgrgid(a) S_my_getgrgid(a)
                static struct group* S_my_getgrgid(gid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrgid) && GETGRGID_R_PROTO == REENTRANT_PROTO_I_TSBI
#       ifdef PERL_CORE
#           define getgrgid(a) (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrgid(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0));})
#           else
#               define getgrgid(a) S_my_getgrgid(a)
                static struct group* S_my_getgrgid(gid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrgid", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrgid) && GETGRGID_R_PROTO == REENTRANT_PROTO_S_TSBI
#       ifdef PERL_CORE
#           define getgrgid(a) (getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrgid", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrgid(a) ({int PL_REENTRANT_RETINT; (getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrgid", a) : 0));})
#           else
#               define getgrgid(a) S_my_getgrgid(a)
                static struct group* S_my_getgrgid(gid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrgid", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETGRGID_R */

#ifdef HAS_GETGRNAM_R
#   undef getgrnam
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_I_CSBWR
#       ifdef PERL_CORE
#           define getgrnam(a) (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrnam(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0));})
#           else
#               define getgrnam(a) S_my_getgrnam(a)
                static struct group* S_my_getgrnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_I_CSBIR
#       ifdef PERL_CORE
#           define getgrnam(a) (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrnam(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0));})
#           else
#               define getgrnam(a) S_my_getgrnam(a)
                static struct group* S_my_getgrnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr))) == 0 ? PL_reentrant_buffer->_grent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_S_CBI
#       ifdef PERL_CORE
#           define getgrnam(a) (getgrnam_r(a, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? PL_reentrant_buffer->_grent_buffer : ((errno == ERANGE) ? Perl_reentrant_retry("getgrnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrnam(a) ({int PL_REENTRANT_RETINT; (getgrnam_r(a, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? PL_reentrant_buffer->_grent_buffer : ((errno == ERANGE) ? Perl_reentrant_retry("getgrnam", a) : 0));})
#           else
#               define getgrnam(a) S_my_getgrnam(a)
                static struct group* S_my_getgrnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getgrnam_r(a, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? PL_reentrant_buffer->_grent_buffer : ((errno == ERANGE) ? Perl_reentrant_retry("getgrnam", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_I_CSBI
#       ifdef PERL_CORE
#           define getgrnam(a) (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrnam(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0));})
#           else
#               define getgrnam(a) S_my_getgrnam(a)
                static struct group* S_my_getgrnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size))) == 0 ? &PL_reentrant_buffer->_grent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getgrnam", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_S_CSBI
#       ifdef PERL_CORE
#           define getgrnam(a) (getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrnam(a) ({int PL_REENTRANT_RETINT; (getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrnam", a) : 0));})
#           else
#               define getgrnam(a) S_my_getgrnam(a)
                static struct group* S_my_getgrnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getgrnam", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETGRNAM_R */

#ifdef HAS_GETHOSTBYADDR_R
#   undef gethostbyaddr
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_CWISBWRE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const char* a, size_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_CWISBWIE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const char* a, size_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_CWISBIE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const char* a, size_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_TWISBIE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const void* a, size_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_CIISBIE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const char* a, int b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_CSBIE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? 1 : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (gethostbyaddr_r(a, b, c, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? 1 : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const char* a, struct hostent* b, char* c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostbyaddr_r(a, b, c, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? 1 : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_TSBIE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? 1 : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (gethostbyaddr_r(a, b, c, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? 1 : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const void* a, struct hostent* b, char* c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostbyaddr_r(a, b, c, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? 1 : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_CWISD
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const char* a, size_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_CIISD
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const char* a, int b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_CII
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c))) == 0 ? 1 : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c))) == 0 ? 1 : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const char* a, int b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c))) == 0 ? 1 : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_TsISBWRE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) S_my_gethostbyaddr(a, b, c)
                static struct hostent* S_my_gethostbyaddr(const void* a, socklen_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETHOSTBYADDR_R */

#ifdef HAS_GETHOSTBYNAME_R
#   undef gethostbyname
#   if !defined(gethostbyname) && GETHOSTBYNAME_R_PROTO == REENTRANT_PROTO_I_CSBWRE
#       ifdef PERL_CORE
#           define gethostbyname(a) (((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyname", a) : 0));})
#           else
#               define gethostbyname(a) S_my_gethostbyname(a)
                static struct hostent* S_my_gethostbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyname", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyname) && GETHOSTBYNAME_R_PROTO == REENTRANT_PROTO_S_CSBIE
#       ifdef PERL_CORE
#           define gethostbyname(a) (gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyname(a) ({int PL_REENTRANT_RETINT; (gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyname", a) : 0));})
#           else
#               define gethostbyname(a) S_my_gethostbyname(a)
                static struct hostent* S_my_gethostbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostbyname", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostbyname) && GETHOSTBYNAME_R_PROTO == REENTRANT_PROTO_I_CSD
#       ifdef PERL_CORE
#           define gethostbyname(a) (((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyname", a) : 0));})
#           else
#               define gethostbyname(a) S_my_gethostbyname(a)
                static struct hostent* S_my_gethostbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostbyname", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETHOSTBYNAME_R */

#ifdef HAS_GETHOSTENT_R
#   undef gethostent
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_I_SBWRE
#       ifdef PERL_CORE
#           define gethostent() (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() S_my_gethostent()
                static struct hostent* S_my_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno))) == 0 ? PL_reentrant_buffer->_hostent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_I_SBIE
#       ifdef PERL_CORE
#           define gethostent() (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() S_my_gethostent()
                static struct hostent* S_my_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_S_SBIE
#       ifdef PERL_CORE
#           define gethostent() (gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; (gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() S_my_gethostent()
                static struct hostent* S_my_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       ifdef PERL_CORE
#           define gethostent() (gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; (gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() S_my_gethostent()
                static struct hostent* S_my_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define gethostent() (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() S_my_gethostent()
                static struct hostent* S_my_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_I_SD
#       ifdef PERL_CORE
#           define gethostent() (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() S_my_gethostent()
                static struct hostent* S_my_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data))) == 0 ? &PL_reentrant_buffer->_hostent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETHOSTENT_R */

#ifdef HAS_GETLOGIN_R
#   undef getlogin
#   if !defined(getlogin) && GETLOGIN_R_PROTO == REENTRANT_PROTO_I_BW
#       ifdef PERL_CORE
#           define getlogin() (((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size))) == 0 ? PL_reentrant_buffer->_getlogin_buffer : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getlogin") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getlogin() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size))) == 0 ? PL_reentrant_buffer->_getlogin_buffer : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getlogin") : 0));})
#           else
#               define getlogin() S_my_getlogin()
                static char* S_my_getlogin() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size))) == 0 ? PL_reentrant_buffer->_getlogin_buffer : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getlogin") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getlogin) && GETLOGIN_R_PROTO == REENTRANT_PROTO_I_BI
#       ifdef PERL_CORE
#           define getlogin() (((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size))) == 0 ? PL_reentrant_buffer->_getlogin_buffer : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getlogin") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getlogin() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size))) == 0 ? PL_reentrant_buffer->_getlogin_buffer : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getlogin") : 0));})
#           else
#               define getlogin() S_my_getlogin()
                static char* S_my_getlogin() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size))) == 0 ? PL_reentrant_buffer->_getlogin_buffer : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getlogin") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getlogin) && GETLOGIN_R_PROTO == REENTRANT_PROTO_B_BW
#       define getlogin() getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)
#   endif
#   if !defined(getlogin) && GETLOGIN_R_PROTO == REENTRANT_PROTO_B_BI
#       define getlogin() getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)
#   endif
#endif /* HAS_GETLOGIN_R */

#ifdef HAS_GETNETBYADDR_R
#   undef getnetbyaddr
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_UISBWRE
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) S_my_getnetbyaddr(a, b)
                static struct netent* S_my_getnetbyaddr(unsigned long a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_LISBI
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) S_my_getnetbyaddr(a, b)
                static struct netent* S_my_getnetbyaddr(long a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_S_TISBI
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; (getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) S_my_getnetbyaddr(a, b)
                static struct netent* S_my_getnetbyaddr(in_addr_t a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_S_LISBI
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; (getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) S_my_getnetbyaddr(a, b)
                static struct netent* S_my_getnetbyaddr(long a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_TISD
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) S_my_getnetbyaddr(a, b)
                static struct netent* S_my_getnetbyaddr(in_addr_t a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_LISD
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) S_my_getnetbyaddr(a, b)
                static struct netent* S_my_getnetbyaddr(long a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_IISD
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) S_my_getnetbyaddr(a, b)
                static struct netent* S_my_getnetbyaddr(int a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_uISBWRE
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) S_my_getnetbyaddr(a, b)
                static struct netent* S_my_getnetbyaddr(uint32_t a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETNETBYADDR_R */

#ifdef HAS_GETNETBYNAME_R
#   undef getnetbyname
#   if !defined(getnetbyname) && GETNETBYNAME_R_PROTO == REENTRANT_PROTO_I_CSBWRE
#       ifdef PERL_CORE
#           define getnetbyname(a) (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0));})
#           else
#               define getnetbyname(a) S_my_getnetbyname(a)
                static struct netent* S_my_getnetbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyname) && GETNETBYNAME_R_PROTO == REENTRANT_PROTO_I_CSBI
#       ifdef PERL_CORE
#           define getnetbyname(a) (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0));})
#           else
#               define getnetbyname(a) S_my_getnetbyname(a)
                static struct netent* S_my_getnetbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyname) && GETNETBYNAME_R_PROTO == REENTRANT_PROTO_S_CSBI
#       ifdef PERL_CORE
#           define getnetbyname(a) (getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyname(a) ({int PL_REENTRANT_RETINT; (getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyname", a) : 0));})
#           else
#               define getnetbyname(a) S_my_getnetbyname(a)
                static struct netent* S_my_getnetbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetbyname", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetbyname) && GETNETBYNAME_R_PROTO == REENTRANT_PROTO_I_CSD
#       ifdef PERL_CORE
#           define getnetbyname(a) (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0));})
#           else
#               define getnetbyname(a) S_my_getnetbyname(a)
                static struct netent* S_my_getnetbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetbyname", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETNETBYNAME_R */

#ifdef HAS_GETNETENT_R
#   undef getnetent
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_I_SBWRE
#       ifdef PERL_CORE
#           define getnetent() (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() S_my_getnetent()
                static struct netent* S_my_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno))) == 0 ? PL_reentrant_buffer->_netent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_I_SBIE
#       ifdef PERL_CORE
#           define getnetent() (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() S_my_getnetent()
                static struct netent* S_my_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_S_SBIE
#       ifdef PERL_CORE
#           define getnetent() (getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; (getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() S_my_getnetent()
                static struct netent* S_my_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       ifdef PERL_CORE
#           define getnetent() (getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; (getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() S_my_getnetent()
                static struct netent* S_my_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getnetent() (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() S_my_getnetent()
                static struct netent* S_my_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_I_SD
#       ifdef PERL_CORE
#           define getnetent() (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() S_my_getnetent()
                static struct netent* S_my_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data))) == 0 ? &PL_reentrant_buffer->_netent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETNETENT_R */

#ifdef HAS_GETPROTOBYNAME_R
#   undef getprotobyname
#   if !defined(getprotobyname) && GETPROTOBYNAME_R_PROTO == REENTRANT_PROTO_I_CSBWR
#       ifdef PERL_CORE
#           define getprotobyname(a) (((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobyname", a) : 0));})
#           else
#               define getprotobyname(a) S_my_getprotobyname(a)
                static struct protoent* S_my_getprotobyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobyname", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getprotobyname) && GETPROTOBYNAME_R_PROTO == REENTRANT_PROTO_S_CSBI
#       ifdef PERL_CORE
#           define getprotobyname(a) (getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotobyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobyname(a) ({int PL_REENTRANT_RETINT; (getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotobyname", a) : 0));})
#           else
#               define getprotobyname(a) S_my_getprotobyname(a)
                static struct protoent* S_my_getprotobyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotobyname", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getprotobyname) && GETPROTOBYNAME_R_PROTO == REENTRANT_PROTO_I_CSD
#       ifdef PERL_CORE
#           define getprotobyname(a) (((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobyname", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobyname", a) : 0));})
#           else
#               define getprotobyname(a) S_my_getprotobyname(a)
                static struct protoent* S_my_getprotobyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobyname", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETPROTOBYNAME_R */

#ifdef HAS_GETPROTOBYNUMBER_R
#   undef getprotobynumber
#   if !defined(getprotobynumber) && GETPROTOBYNUMBER_R_PROTO == REENTRANT_PROTO_I_ISBWR
#       ifdef PERL_CORE
#           define getprotobynumber(a) (((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobynumber", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobynumber(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobynumber", a) : 0));})
#           else
#               define getprotobynumber(a) S_my_getprotobynumber(a)
                static struct protoent* S_my_getprotobynumber(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobynumber", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getprotobynumber) && GETPROTOBYNUMBER_R_PROTO == REENTRANT_PROTO_S_ISBI
#       ifdef PERL_CORE
#           define getprotobynumber(a) (getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotobynumber", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobynumber(a) ({int PL_REENTRANT_RETINT; (getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotobynumber", a) : 0));})
#           else
#               define getprotobynumber(a) S_my_getprotobynumber(a)
                static struct protoent* S_my_getprotobynumber(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotobynumber", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getprotobynumber) && GETPROTOBYNUMBER_R_PROTO == REENTRANT_PROTO_I_ISD
#       ifdef PERL_CORE
#           define getprotobynumber(a) (((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobynumber", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobynumber(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobynumber", a) : 0));})
#           else
#               define getprotobynumber(a) S_my_getprotobynumber(a)
                static struct protoent* S_my_getprotobynumber(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotobynumber", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETPROTOBYNUMBER_R */

#ifdef HAS_GETPROTOENT_R
#   undef getprotoent
#   if !defined(getprotoent) && GETPROTOENT_R_PROTO == REENTRANT_PROTO_I_SBWR
#       ifdef PERL_CORE
#           define getprotoent() (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotoent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0));})
#           else
#               define getprotoent() S_my_getprotoent()
                static struct protoent* S_my_getprotoent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr))) == 0 ? PL_reentrant_buffer->_protoent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getprotoent) && GETPROTOENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getprotoent() (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotoent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0));})
#           else
#               define getprotoent() S_my_getprotoent()
                static struct protoent* S_my_getprotoent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getprotoent) && GETPROTOENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       ifdef PERL_CORE
#           define getprotoent() (getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotoent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotoent() ({int PL_REENTRANT_RETINT; (getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotoent") : 0));})
#           else
#               define getprotoent() S_my_getprotoent()
                static struct protoent* S_my_getprotoent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getprotoent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getprotoent) && GETPROTOENT_R_PROTO == REENTRANT_PROTO_I_SD
#       ifdef PERL_CORE
#           define getprotoent() (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotoent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0));})
#           else
#               define getprotoent() S_my_getprotoent()
                static struct protoent* S_my_getprotoent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data))) == 0 ? &PL_reentrant_buffer->_protoent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getprotoent") : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETPROTOENT_R */

#ifdef HAS_GETPWENT_R
#   undef getpwent
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_I_SBWR
#       ifdef PERL_CORE
#           define getpwent() (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() S_my_getpwent()
                static struct passwd* S_my_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_I_SBIR
#       ifdef PERL_CORE
#           define getpwent() (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() S_my_getpwent()
                static struct passwd* S_my_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_S_SBW
#       ifdef PERL_CORE
#           define getpwent() (getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; (getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() S_my_getpwent()
                static struct passwd* S_my_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       ifdef PERL_CORE
#           define getpwent() (getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; (getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() S_my_getpwent()
                static struct passwd* S_my_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getpwent() (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() S_my_getpwent()
                static struct passwd* S_my_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_I_SBIH
#       ifdef PERL_CORE
#           define getpwent() (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_fptr))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_fptr))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() S_my_getpwent()
                static struct passwd* S_my_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_fptr))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETPWENT_R */

#ifdef HAS_GETPWNAM_R
#   undef getpwnam
#   if !defined(getpwnam) && GETPWNAM_R_PROTO == REENTRANT_PROTO_I_CSBWR
#       ifdef PERL_CORE
#           define getpwnam(a) (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwnam(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0));})
#           else
#               define getpwnam(a) S_my_getpwnam(a)
                static struct passwd* S_my_getpwnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwnam) && GETPWNAM_R_PROTO == REENTRANT_PROTO_I_CSBIR
#       ifdef PERL_CORE
#           define getpwnam(a) (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwnam(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0));})
#           else
#               define getpwnam(a) S_my_getpwnam(a)
                static struct passwd* S_my_getpwnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwnam) && GETPWNAM_R_PROTO == REENTRANT_PROTO_S_CSBI
#       ifdef PERL_CORE
#           define getpwnam(a) (getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwnam(a) ({int PL_REENTRANT_RETINT; (getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwnam", a) : 0));})
#           else
#               define getpwnam(a) S_my_getpwnam(a)
                static struct passwd* S_my_getpwnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwnam", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwnam) && GETPWNAM_R_PROTO == REENTRANT_PROTO_I_CSBI
#       ifdef PERL_CORE
#           define getpwnam(a) (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwnam(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0));})
#           else
#               define getpwnam(a) S_my_getpwnam(a)
                static struct passwd* S_my_getpwnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwnam", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETPWNAM_R */

#ifdef HAS_GETPWUID_R
#   undef getpwuid
#   if !defined(getpwuid) && GETPWUID_R_PROTO == REENTRANT_PROTO_I_TSBWR
#       ifdef PERL_CORE
#           define getpwuid(a) (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwuid(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0));})
#           else
#               define getpwuid(a) S_my_getpwuid(a)
                static struct passwd* S_my_getpwuid(uid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwuid) && GETPWUID_R_PROTO == REENTRANT_PROTO_I_TSBIR
#       ifdef PERL_CORE
#           define getpwuid(a) (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwuid(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0));})
#           else
#               define getpwuid(a) S_my_getpwuid(a)
                static struct passwd* S_my_getpwuid(uid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr))) == 0 ? PL_reentrant_buffer->_pwent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwuid) && GETPWUID_R_PROTO == REENTRANT_PROTO_I_TSBI
#       ifdef PERL_CORE
#           define getpwuid(a) (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwuid(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0));})
#           else
#               define getpwuid(a) S_my_getpwuid(a)
                static struct passwd* S_my_getpwuid(uid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size))) == 0 ? &PL_reentrant_buffer->_pwent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getpwuid", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getpwuid) && GETPWUID_R_PROTO == REENTRANT_PROTO_S_TSBI
#       ifdef PERL_CORE
#           define getpwuid(a) (getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwuid", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwuid(a) ({int PL_REENTRANT_RETINT; (getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwuid", a) : 0));})
#           else
#               define getpwuid(a) S_my_getpwuid(a)
                static struct passwd* S_my_getpwuid(uid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getpwuid", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETPWUID_R */

#ifdef HAS_GETSERVBYNAME_R
#   undef getservbyname
#   if !defined(getservbyname) && GETSERVBYNAME_R_PROTO == REENTRANT_PROTO_I_CCSBWR
#       ifdef PERL_CORE
#           define getservbyname(a, b) (((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyname", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyname(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyname", a, b) : 0));})
#           else
#               define getservbyname(a, b) S_my_getservbyname(a, b)
                static struct servent* S_my_getservbyname(const char* a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyname", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getservbyname) && GETSERVBYNAME_R_PROTO == REENTRANT_PROTO_S_CCSBI
#       ifdef PERL_CORE
#           define getservbyname(a, b) (getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservbyname", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyname(a, b) ({int PL_REENTRANT_RETINT; (getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservbyname", a, b) : 0));})
#           else
#               define getservbyname(a, b) S_my_getservbyname(a, b)
                static struct servent* S_my_getservbyname(const char* a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservbyname", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getservbyname) && GETSERVBYNAME_R_PROTO == REENTRANT_PROTO_I_CCSD
#       ifdef PERL_CORE
#           define getservbyname(a, b) (((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyname", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyname(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyname", a, b) : 0));})
#           else
#               define getservbyname(a, b) S_my_getservbyname(a, b)
                static struct servent* S_my_getservbyname(const char* a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyname", a, b) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETSERVBYNAME_R */

#ifdef HAS_GETSERVBYPORT_R
#   undef getservbyport
#   if !defined(getservbyport) && GETSERVBYPORT_R_PROTO == REENTRANT_PROTO_I_ICSBWR
#       ifdef PERL_CORE
#           define getservbyport(a, b) (((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyport", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyport(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyport", a, b) : 0));})
#           else
#               define getservbyport(a, b) S_my_getservbyport(a, b)
                static struct servent* S_my_getservbyport(int a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyport", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getservbyport) && GETSERVBYPORT_R_PROTO == REENTRANT_PROTO_S_ICSBI
#       ifdef PERL_CORE
#           define getservbyport(a, b) (getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservbyport", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyport(a, b) ({int PL_REENTRANT_RETINT; (getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservbyport", a, b) : 0));})
#           else
#               define getservbyport(a, b) S_my_getservbyport(a, b)
                static struct servent* S_my_getservbyport(int a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservbyport", a, b) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getservbyport) && GETSERVBYPORT_R_PROTO == REENTRANT_PROTO_I_ICSD
#       ifdef PERL_CORE
#           define getservbyport(a, b) (((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyport", a, b) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyport(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyport", a, b) : 0));})
#           else
#               define getservbyport(a, b) S_my_getservbyport(a, b)
                static struct servent* S_my_getservbyport(int a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservbyport", a, b) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETSERVBYPORT_R */

#ifdef HAS_GETSERVENT_R
#   undef getservent
#   if !defined(getservent) && GETSERVENT_R_PROTO == REENTRANT_PROTO_I_SBWR
#       ifdef PERL_CORE
#           define getservent() (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0));})
#           else
#               define getservent() S_my_getservent()
                static struct servent* S_my_getservent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr))) == 0 ? PL_reentrant_buffer->_servent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getservent) && GETSERVENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getservent() (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0));})
#           else
#               define getservent() S_my_getservent()
                static struct servent* S_my_getservent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getservent) && GETSERVENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       ifdef PERL_CORE
#           define getservent() (getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservent() ({int PL_REENTRANT_RETINT; (getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservent") : 0));})
#           else
#               define getservent() S_my_getservent()
                static struct servent* S_my_getservent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getservent") : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getservent) && GETSERVENT_R_PROTO == REENTRANT_PROTO_I_SD
#       ifdef PERL_CORE
#           define getservent() (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0));})
#           else
#               define getservent() S_my_getservent()
                static struct servent* S_my_getservent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data))) == 0 ? &PL_reentrant_buffer->_servent_struct : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getservent") : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETSERVENT_R */

#ifdef HAS_GETSPNAM_R
#   undef getspnam
#   if !defined(getspnam) && GETSPNAM_R_PROTO == REENTRANT_PROTO_I_CSBWR
#       ifdef PERL_CORE
#           define getspnam(a) (((PL_REENTRANT_RETINT = getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size, &PL_reentrant_buffer->_spent_ptr))) == 0 ? PL_reentrant_buffer->_spent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getspnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getspnam(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size, &PL_reentrant_buffer->_spent_ptr))) == 0 ? PL_reentrant_buffer->_spent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getspnam", a) : 0));})
#           else
#               define getspnam(a) S_my_getspnam(a)
                static struct spwd* S_my_getspnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size, &PL_reentrant_buffer->_spent_ptr))) == 0 ? PL_reentrant_buffer->_spent_ptr : (((PL_REENTRANT_RETINT == ERANGE) || (errno == ERANGE)) ? Perl_reentrant_retry("getspnam", a) : 0));
                }
#           endif
#       endif
#   endif
#   if !defined(getspnam) && GETSPNAM_R_PROTO == REENTRANT_PROTO_S_CSBI
#       ifdef PERL_CORE
#           define getspnam(a) (getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size) ? &PL_reentrant_buffer->_spent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getspnam", a) : 0))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getspnam(a) ({int PL_REENTRANT_RETINT; (getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size) ? &PL_reentrant_buffer->_spent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getspnam", a) : 0));})
#           else
#               define getspnam(a) S_my_getspnam(a)
                static struct spwd* S_my_getspnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size) ? &PL_reentrant_buffer->_spent_struct : ((errno == ERANGE) ? Perl_reentrant_retry("getspnam", a) : 0));
                }
#           endif
#       endif
#   endif
#endif /* HAS_GETSPNAM_R */

#ifdef HAS_GMTIME_R
#   undef gmtime
#   if !defined(gmtime) && GMTIME_R_PROTO == REENTRANT_PROTO_S_TS
#       ifdef PERL_CORE
#           define gmtime(a) (gmtime_r(a, &PL_reentrant_buffer->_gmtime_struct) ? &PL_reentrant_buffer->_gmtime_struct : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gmtime(a) ({int PL_REENTRANT_RETINT; (gmtime_r(a, &PL_reentrant_buffer->_gmtime_struct) ? &PL_reentrant_buffer->_gmtime_struct : 0);})
#           else
#               define gmtime(a) S_my_gmtime(a)
                static struct tm* S_my_gmtime(const time_t* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (gmtime_r(a, &PL_reentrant_buffer->_gmtime_struct) ? &PL_reentrant_buffer->_gmtime_struct : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(gmtime) && GMTIME_R_PROTO == REENTRANT_PROTO_I_TS
#       ifdef PERL_CORE
#           define gmtime(a) (((PL_REENTRANT_RETINT = gmtime_r(a, &PL_reentrant_buffer->_gmtime_struct))) == 0 ? &PL_reentrant_buffer->_gmtime_struct : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gmtime(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = gmtime_r(a, &PL_reentrant_buffer->_gmtime_struct))) == 0 ? &PL_reentrant_buffer->_gmtime_struct : 0);})
#           else
#               define gmtime(a) S_my_gmtime(a)
                static struct tm* S_my_gmtime(const time_t* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = gmtime_r(a, &PL_reentrant_buffer->_gmtime_struct))) == 0 ? &PL_reentrant_buffer->_gmtime_struct : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_GMTIME_R */

#ifdef HAS_LOCALTIME_R
#   undef localtime
#   if !defined(localtime) && LOCALTIME_R_PROTO == REENTRANT_PROTO_S_TS
#       ifdef PERL_CORE
#           define localtime(a) (localtime_r(a, &PL_reentrant_buffer->_localtime_struct) ? &PL_reentrant_buffer->_localtime_struct : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define localtime(a) ({int PL_REENTRANT_RETINT; (localtime_r(a, &PL_reentrant_buffer->_localtime_struct) ? &PL_reentrant_buffer->_localtime_struct : 0);})
#           else
#               define localtime(a) S_my_localtime(a)
                static struct tm* S_my_localtime(const time_t* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (localtime_r(a, &PL_reentrant_buffer->_localtime_struct) ? &PL_reentrant_buffer->_localtime_struct : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(localtime) && LOCALTIME_R_PROTO == REENTRANT_PROTO_I_TS
#       ifdef PERL_CORE
#           define localtime(a) (((PL_REENTRANT_RETINT = localtime_r(a, &PL_reentrant_buffer->_localtime_struct))) == 0 ? &PL_reentrant_buffer->_localtime_struct : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define localtime(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = localtime_r(a, &PL_reentrant_buffer->_localtime_struct))) == 0 ? &PL_reentrant_buffer->_localtime_struct : 0);})
#           else
#               define localtime(a) S_my_localtime(a)
                static struct tm* S_my_localtime(const time_t* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = localtime_r(a, &PL_reentrant_buffer->_localtime_struct))) == 0 ? &PL_reentrant_buffer->_localtime_struct : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_LOCALTIME_R */

#ifdef HAS_RANDOM_R
#   undef random
#   if !defined(random) && RANDOM_R_PROTO == REENTRANT_PROTO_I_iS
#       ifdef PERL_CORE
#           define random() (random_r(&PL_reentrant_buffer->_random_retval, &PL_reentrant_buffer->_random_struct) == 0 ? PL_reentrant_buffer->_random_retval : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define random() ({int PL_REENTRANT_RETINT; (random_r(&PL_reentrant_buffer->_random_retval, &PL_reentrant_buffer->_random_struct) == 0 ? PL_reentrant_buffer->_random_retval : 0);})
#           else
#               define random() S_my_random()
                static long S_my_random() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (random_r(&PL_reentrant_buffer->_random_retval, &PL_reentrant_buffer->_random_struct) == 0 ? PL_reentrant_buffer->_random_retval : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(random) && RANDOM_R_PROTO == REENTRANT_PROTO_I_lS
#       ifdef PERL_CORE
#           define random() (random_r(&PL_reentrant_buffer->_random_retval, &PL_reentrant_buffer->_random_struct) == 0 ? PL_reentrant_buffer->_random_retval : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define random() ({int PL_REENTRANT_RETINT; (random_r(&PL_reentrant_buffer->_random_retval, &PL_reentrant_buffer->_random_struct) == 0 ? PL_reentrant_buffer->_random_retval : 0);})
#           else
#               define random() S_my_random()
                static long S_my_random() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (random_r(&PL_reentrant_buffer->_random_retval, &PL_reentrant_buffer->_random_struct) == 0 ? PL_reentrant_buffer->_random_retval : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(random) && RANDOM_R_PROTO == REENTRANT_PROTO_I_St
#       ifdef PERL_CORE
#           define random() (random_r(&PL_reentrant_buffer->_random_struct, &PL_reentrant_buffer->_random_retval) == 0 ? PL_reentrant_buffer->_random_retval : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define random() ({int PL_REENTRANT_RETINT; (random_r(&PL_reentrant_buffer->_random_struct, &PL_reentrant_buffer->_random_retval) == 0 ? PL_reentrant_buffer->_random_retval : 0);})
#           else
#               define random() S_my_random()
                static long S_my_random() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (random_r(&PL_reentrant_buffer->_random_struct, &PL_reentrant_buffer->_random_retval) == 0 ? PL_reentrant_buffer->_random_retval : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_RANDOM_R */

#ifdef HAS_READDIR_R
#   undef readdir
#   if !defined(readdir) && READDIR_R_PROTO == REENTRANT_PROTO_I_TSR
#       ifdef PERL_CORE
#           define readdir(a) (((PL_REENTRANT_RETINT = readdir_r(a, PL_reentrant_buffer->_readdir_struct, &PL_reentrant_buffer->_readdir_ptr))) == 0 ? PL_reentrant_buffer->_readdir_ptr : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define readdir(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = readdir_r(a, PL_reentrant_buffer->_readdir_struct, &PL_reentrant_buffer->_readdir_ptr))) == 0 ? PL_reentrant_buffer->_readdir_ptr : 0);})
#           else
#               define readdir(a) S_my_readdir(a)
                static struct dirent* S_my_readdir(DIR* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = readdir_r(a, PL_reentrant_buffer->_readdir_struct, &PL_reentrant_buffer->_readdir_ptr))) == 0 ? PL_reentrant_buffer->_readdir_ptr : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(readdir) && READDIR_R_PROTO == REENTRANT_PROTO_I_TS
#       ifdef PERL_CORE
#           define readdir(a) (((PL_REENTRANT_RETINT = readdir_r(a, PL_reentrant_buffer->_readdir_struct))) == 0 ? PL_reentrant_buffer->_readdir_struct : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define readdir(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = readdir_r(a, PL_reentrant_buffer->_readdir_struct))) == 0 ? PL_reentrant_buffer->_readdir_struct : 0);})
#           else
#               define readdir(a) S_my_readdir(a)
                static struct dirent* S_my_readdir(DIR* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = readdir_r(a, PL_reentrant_buffer->_readdir_struct))) == 0 ? PL_reentrant_buffer->_readdir_struct : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_READDIR_R */

#ifdef HAS_READDIR64_R
#   undef readdir64
#   if !defined(readdir64) && READDIR64_R_PROTO == REENTRANT_PROTO_I_TSR
#       ifdef PERL_CORE
#           define readdir64(a) (((PL_REENTRANT_RETINT = readdir64_r(a, PL_reentrant_buffer->_readdir64_struct, &PL_reentrant_buffer->_readdir64_ptr))) == 0 ? PL_reentrant_buffer->_readdir64_ptr : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define readdir64(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = readdir64_r(a, PL_reentrant_buffer->_readdir64_struct, &PL_reentrant_buffer->_readdir64_ptr))) == 0 ? PL_reentrant_buffer->_readdir64_ptr : 0);})
#           else
#               define readdir64(a) S_my_readdir64(a)
                static struct dirent64* S_my_readdir64(DIR* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = readdir64_r(a, PL_reentrant_buffer->_readdir64_struct, &PL_reentrant_buffer->_readdir64_ptr))) == 0 ? PL_reentrant_buffer->_readdir64_ptr : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(readdir64) && READDIR64_R_PROTO == REENTRANT_PROTO_I_TS
#       ifdef PERL_CORE
#           define readdir64(a) (((PL_REENTRANT_RETINT = readdir64_r(a, PL_reentrant_buffer->_readdir64_struct))) == 0 ? PL_reentrant_buffer->_readdir64_struct : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define readdir64(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = readdir64_r(a, PL_reentrant_buffer->_readdir64_struct))) == 0 ? PL_reentrant_buffer->_readdir64_struct : 0);})
#           else
#               define readdir64(a) S_my_readdir64(a)
                static struct dirent64* S_my_readdir64(DIR* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = readdir64_r(a, PL_reentrant_buffer->_readdir64_struct))) == 0 ? PL_reentrant_buffer->_readdir64_struct : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_READDIR64_R */

#ifdef HAS_SETGRENT_R
#   undef setgrent
#   if !defined(setgrent) && SETGRENT_R_PROTO == REENTRANT_PROTO_I_H
#       ifdef PERL_CORE
#           define setgrent() (((PL_REENTRANT_RETINT = setgrent_r(&PL_reentrant_buffer->_grent_fptr))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define setgrent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = setgrent_r(&PL_reentrant_buffer->_grent_fptr))) == 0 ? 1 : 0);})
#           else
#               define setgrent() S_my_setgrent()
                static void S_my_setgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = setgrent_r(&PL_reentrant_buffer->_grent_fptr))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(setgrent) && SETGRENT_R_PROTO == REENTRANT_PROTO_V_H
#       define setgrent() setgrent_r(&PL_reentrant_buffer->_grent_fptr)
#   endif
#endif /* HAS_SETGRENT_R */

#ifdef HAS_SETHOSTENT_R
#   undef sethostent
#   if !defined(sethostent) && SETHOSTENT_R_PROTO == REENTRANT_PROTO_I_ID
#       ifdef PERL_CORE
#           define sethostent(a) (((PL_REENTRANT_RETINT = sethostent_r(a, &PL_reentrant_buffer->_hostent_data))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define sethostent(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = sethostent_r(a, &PL_reentrant_buffer->_hostent_data))) == 0 ? 1 : 0);})
#           else
#               define sethostent(a) S_my_sethostent(a)
                static void S_my_sethostent(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = sethostent_r(a, &PL_reentrant_buffer->_hostent_data))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(sethostent) && SETHOSTENT_R_PROTO == REENTRANT_PROTO_V_ID
#       define sethostent(a) sethostent_r(a, &PL_reentrant_buffer->_hostent_data)
#   endif
#endif /* HAS_SETHOSTENT_R */

#ifdef HAS_SETLOCALE_R
#   undef setlocale
#   if !defined(setlocale) && SETLOCALE_R_PROTO == REENTRANT_PROTO_I_ICBI
#       ifdef PERL_CORE
#           define setlocale(a, b) (((PL_REENTRANT_RETINT = setlocale_r(a, b, PL_reentrant_buffer->_setlocale_buffer, PL_reentrant_buffer->_setlocale_size))) == 0 ? PL_reentrant_buffer->_setlocale_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define setlocale(a, b) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = setlocale_r(a, b, PL_reentrant_buffer->_setlocale_buffer, PL_reentrant_buffer->_setlocale_size))) == 0 ? PL_reentrant_buffer->_setlocale_buffer : 0);})
#           else
#               define setlocale(a, b) S_my_setlocale(a, b)
                static char* S_my_setlocale(int a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = setlocale_r(a, b, PL_reentrant_buffer->_setlocale_buffer, PL_reentrant_buffer->_setlocale_size))) == 0 ? PL_reentrant_buffer->_setlocale_buffer : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_SETLOCALE_R */

#ifdef HAS_SETNETENT_R
#   undef setnetent
#   if !defined(setnetent) && SETNETENT_R_PROTO == REENTRANT_PROTO_I_ID
#       ifdef PERL_CORE
#           define setnetent(a) (((PL_REENTRANT_RETINT = setnetent_r(a, &PL_reentrant_buffer->_netent_data))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define setnetent(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = setnetent_r(a, &PL_reentrant_buffer->_netent_data))) == 0 ? 1 : 0);})
#           else
#               define setnetent(a) S_my_setnetent(a)
                static void S_my_setnetent(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = setnetent_r(a, &PL_reentrant_buffer->_netent_data))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(setnetent) && SETNETENT_R_PROTO == REENTRANT_PROTO_V_ID
#       define setnetent(a) setnetent_r(a, &PL_reentrant_buffer->_netent_data)
#   endif
#endif /* HAS_SETNETENT_R */

#ifdef HAS_SETPROTOENT_R
#   undef setprotoent
#   if !defined(setprotoent) && SETPROTOENT_R_PROTO == REENTRANT_PROTO_I_ID
#       ifdef PERL_CORE
#           define setprotoent(a) (((PL_REENTRANT_RETINT = setprotoent_r(a, &PL_reentrant_buffer->_protoent_data))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define setprotoent(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = setprotoent_r(a, &PL_reentrant_buffer->_protoent_data))) == 0 ? 1 : 0);})
#           else
#               define setprotoent(a) S_my_setprotoent(a)
                static void S_my_setprotoent(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = setprotoent_r(a, &PL_reentrant_buffer->_protoent_data))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(setprotoent) && SETPROTOENT_R_PROTO == REENTRANT_PROTO_V_ID
#       define setprotoent(a) setprotoent_r(a, &PL_reentrant_buffer->_protoent_data)
#   endif
#endif /* HAS_SETPROTOENT_R */

#ifdef HAS_SETPWENT_R
#   undef setpwent
#   if !defined(setpwent) && SETPWENT_R_PROTO == REENTRANT_PROTO_I_H
#       ifdef PERL_CORE
#           define setpwent() (((PL_REENTRANT_RETINT = setpwent_r(&PL_reentrant_buffer->_pwent_fptr))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define setpwent() ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = setpwent_r(&PL_reentrant_buffer->_pwent_fptr))) == 0 ? 1 : 0);})
#           else
#               define setpwent() S_my_setpwent()
                static void S_my_setpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = setpwent_r(&PL_reentrant_buffer->_pwent_fptr))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(setpwent) && SETPWENT_R_PROTO == REENTRANT_PROTO_V_H
#       define setpwent() setpwent_r(&PL_reentrant_buffer->_pwent_fptr)
#   endif
#endif /* HAS_SETPWENT_R */

#ifdef HAS_SETSERVENT_R
#   undef setservent
#   if !defined(setservent) && SETSERVENT_R_PROTO == REENTRANT_PROTO_I_ID
#       ifdef PERL_CORE
#           define setservent(a) (((PL_REENTRANT_RETINT = setservent_r(a, &PL_reentrant_buffer->_servent_data))) == 0 ? 1 : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define setservent(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = setservent_r(a, &PL_reentrant_buffer->_servent_data))) == 0 ? 1 : 0);})
#           else
#               define setservent(a) S_my_setservent(a)
                static void S_my_setservent(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = setservent_r(a, &PL_reentrant_buffer->_servent_data))) == 0 ? 1 : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(setservent) && SETSERVENT_R_PROTO == REENTRANT_PROTO_V_ID
#       define setservent(a) setservent_r(a, &PL_reentrant_buffer->_servent_data)
#   endif
#endif /* HAS_SETSERVENT_R */

#ifdef HAS_SRAND48_R
#   undef srand48
#   if !defined(srand48) && SRAND48_R_PROTO == REENTRANT_PROTO_I_LS
#       ifdef PERL_CORE
#           define srand48(a) (((PL_REENTRANT_RETINT = srand48_r(a, &PL_reentrant_buffer->_drand48_struct))) == 0 ? &PL_reentrant_buffer->_drand48_struct : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define srand48(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = srand48_r(a, &PL_reentrant_buffer->_drand48_struct))) == 0 ? &PL_reentrant_buffer->_drand48_struct : 0);})
#           else
#               define srand48(a) S_my_srand48(a)
                static void S_my_srand48(long a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = srand48_r(a, &PL_reentrant_buffer->_drand48_struct))) == 0 ? &PL_reentrant_buffer->_drand48_struct : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_SRAND48_R */

#ifdef HAS_SRANDOM_R
#   undef srandom
#   if !defined(srandom) && SRANDOM_R_PROTO == REENTRANT_PROTO_I_TS
#       ifdef PERL_CORE
#           define srandom(a) (((PL_REENTRANT_RETINT = srandom_r(a, &PL_reentrant_buffer->_srandom_struct))) == 0 ? &PL_reentrant_buffer->_srandom_struct : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define srandom(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = srandom_r(a, &PL_reentrant_buffer->_srandom_struct))) == 0 ? &PL_reentrant_buffer->_srandom_struct : 0);})
#           else
#               define srandom(a) S_my_srandom(a)
                static void S_my_srandom(unsigned int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    (((PL_REENTRANT_RETINT = srandom_r(a, &PL_reentrant_buffer->_srandom_struct))) == 0 ? &PL_reentrant_buffer->_srandom_struct : 0);
                }
#           endif
#       endif
#   endif
#endif /* HAS_SRANDOM_R */

#ifdef HAS_STRERROR_R
#   undef strerror
#   if !defined(strerror) && STRERROR_R_PROTO == REENTRANT_PROTO_I_IBW
#       ifdef PERL_CORE
#           define strerror(a) (((PL_REENTRANT_RETINT = strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size))) == 0 ? PL_reentrant_buffer->_strerror_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define strerror(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size))) == 0 ? PL_reentrant_buffer->_strerror_buffer : 0);})
#           else
#               define strerror(a) S_my_strerror(a)
                static char* S_my_strerror(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size))) == 0 ? PL_reentrant_buffer->_strerror_buffer : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(strerror) && STRERROR_R_PROTO == REENTRANT_PROTO_I_IBI
#       ifdef PERL_CORE
#           define strerror(a) (((PL_REENTRANT_RETINT = strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size))) == 0 ? PL_reentrant_buffer->_strerror_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define strerror(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size))) == 0 ? PL_reentrant_buffer->_strerror_buffer : 0);})
#           else
#               define strerror(a) S_my_strerror(a)
                static char* S_my_strerror(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size))) == 0 ? PL_reentrant_buffer->_strerror_buffer : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(strerror) && STRERROR_R_PROTO == REENTRANT_PROTO_B_IBW
#       define strerror(a) strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size)
#   endif
#endif /* HAS_STRERROR_R */

#ifdef HAS_TMPNAM_R
#   undef tmpnam
#   if !defined(tmpnam) && TMPNAM_R_PROTO == REENTRANT_PROTO_B_B
#       define tmpnam(a) tmpnam_r(a)
#   endif
#endif /* HAS_TMPNAM_R */

#ifdef HAS_TTYNAME_R
#   undef ttyname
#   if !defined(ttyname) && TTYNAME_R_PROTO == REENTRANT_PROTO_I_IBW
#       ifdef PERL_CORE
#           define ttyname(a) (((PL_REENTRANT_RETINT = ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size))) == 0 ? PL_reentrant_buffer->_ttyname_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define ttyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size))) == 0 ? PL_reentrant_buffer->_ttyname_buffer : 0);})
#           else
#               define ttyname(a) S_my_ttyname(a)
                static char* S_my_ttyname(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size))) == 0 ? PL_reentrant_buffer->_ttyname_buffer : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(ttyname) && TTYNAME_R_PROTO == REENTRANT_PROTO_I_IBI
#       ifdef PERL_CORE
#           define ttyname(a) (((PL_REENTRANT_RETINT = ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size))) == 0 ? PL_reentrant_buffer->_ttyname_buffer : 0)
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define ttyname(a) ({int PL_REENTRANT_RETINT; (((PL_REENTRANT_RETINT = ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size))) == 0 ? PL_reentrant_buffer->_ttyname_buffer : 0);})
#           else
#               define ttyname(a) S_my_ttyname(a)
                static char* S_my_ttyname(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    return (((PL_REENTRANT_RETINT = ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size))) == 0 ? PL_reentrant_buffer->_ttyname_buffer : 0);
                }
#           endif
#       endif
#   endif
#   if !defined(ttyname) && TTYNAME_R_PROTO == REENTRANT_PROTO_B_IBI
#       define ttyname(a) ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size)
#   endif
#endif /* HAS_TTYNAME_R */



#endif /* USE_REENTRANT_API */
 
#endif

