package HTML::Video::Embed::Site::Youtube;
use Moo;

with 'HTML::Video::Embed::Module';

sub _build_domain_reg{
    return qr/youtube\.com/;
}

sub _build_validate_reg{
    return qr|^([a-zA-Z0-9-_]{11})$|;
}

has 'timecode_reg' => (
    'is' => 'lazy',
);

sub _build_timecode_reg{
    return qr/((?:\d+h)?(?:\d+m)?\d+s)/;
}

sub process{
    my ( $self, $embeder, $uri ) = @_;

    my ( $vid ) = ( $uri->query_param('v') || '' ) =~ m/${ \$self->validate_reg }/;

    return $self->_process( $embeder, $vid, $uri );
}

sub _process{
    my ( $self, $embeder, $vid, $uri ) = @_;

    if ( $vid ){
        my $timecode = $uri->query_param('t') || $uri->fragment || '';
        if ( 
            defined( $timecode )
            && ( $timecode =~ m/${ \$self->timecode_reg }/ )
        ){
            $vid .= "#t=${1}";
        }

        return qq|<iframe class="${ \$embeder->class }" src="http://www.youtube.com/embed/${vid}" frameborder="0" allowfullscreen="1"></iframe>|;
    }

    return undef;
}

1;
