use Test::More tests => 2;

use FindBin;
use lib "$FindBin::Bin/../lib";
use strict;
use warnings;
use DateTime::Span::Birthdate;
use DateTime::Age qw/to_age/;

use Data::Dumper;

my $age = to_age( 2, 6, 1983 );
my $span  = DateTime::Span::Birthdate->new( age => $age );
my $start = $span->start->{local_c};
my $end   = $span->end->{local_c};
ok( ( to_age( $start->{year}, $start->{month}, $start->{day} ) eq $age ) == 1, 'test compare start' );
ok( ( to_age( $end->{year},   $end->{month},   $end->{day} ) eq $age ) == 1,   'test compare end' );

