#!/usr/bin/perl -w
use Test::More tests => 32;
use Math::Currency qw($LC_MONETARY);

# monetary_locale testing
use POSIX qw( locale_h );
my $locale = setlocale( LC_ALL, "en_GB" );
my $format = {};
Math::Currency->localize( \$format );

# monetary_locale testing
#use POSIX qw( locale_h );
#my $locale;
#
#SKIP: {
#	$locale = setlocale(LC_ALL,"en_GB");
#	skip ("No en_GB locale installed", 1)
#	    unless setlocale(LC_ALL) eq "en_GB";
#	skip ("No locale support", 3) unless $CLASS->localize();
#	pass ( "Re-initialized locale with en_GB" );
#	is ( $FORMAT->{INT_CURR_SYMBOL}, "GBP ", "POSIX format set properly");
#
#	$pounds = $CLASS->new( 98994.95, 'GBP');
#	is ( $pounds, '£98,994.95', "changes to object format" );
#	$newpounds = $pounds + 100000;
#
#	is ( ref($newpounds), ref($pounds), "autoupgrade to object" );
#    }
#
#SKIP: {
#	$locale = setlocale(LC_ALL,"en_US");
#	skip ("No en_US locale installed", 1)
#	    unless setlocale(LC_ALL) eq "en_US";
#	$CLASS->always_init(1);
#	is ( $dollars, '$20.01', "POSIX format reset properly");
#	$CLASS->always_init(0);
#}

SKIP: {
    skip ("No locale support", 16) unless Math::Currency->localize();
    pass("Re-initialized locale with en_GB");

    foreach my $param qw(
      INT_CURR_SYMBOL CURRENCY_SYMBOL MON_DECIMAL_POINT
      MON_THOUSANDS_SEP MON_GROUPING POSITIVE_SIGN
      NEGATIVE_SIGN INT_FRAC_DIGITS FRAC_DIGITS
      P_CS_PRECEDES P_SEP_BY_SPACE N_CS_PRECEDES
      N_SEP_BY_SPACE P_SIGN_POSN N_SIGN_POSN
      )    # hardcoded keys to be sure they are all there
      {
        ok( defined $format->{$param},
            sprintf( " \t%-20s = '%s'", $param, $format->{$param} ) );
      }

}

SKIP: {
# conveniently the $format is still in scope

    skip ("No locale support", 16) 
    	unless $format->{INT_CURR_SYMBOL} =~ /GBP/;

    use_ok("Math::Currency::en_GB");
    foreach my $param qw(
      INT_CURR_SYMBOL CURRENCY_SYMBOL MON_DECIMAL_POINT
      MON_THOUSANDS_SEP MON_GROUPING POSITIVE_SIGN
      NEGATIVE_SIGN INT_FRAC_DIGITS FRAC_DIGITS
      P_CS_PRECEDES P_SEP_BY_SPACE N_CS_PRECEDES
      N_SEP_BY_SPACE P_SIGN_POSN N_SIGN_POSN
      )    # hardcoded keys to be sure they are all there
      {
	my $global_param = $LC_MONETARY->{'en_GB'}->{$param};
        ok( $format->{$param} eq $global_param,
            sprintf( " \t'%s'\t= '%s'", $format->{$param}, $global_param ) );
      }
}
SKIP: {
    my $mckensie = Math::Currency->new("4.56","CAD");
}
