/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementLine
extends AbstractElement {
    private final char separator;

    public ElementLine(char c) {
        this.separator = c;
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        return new Dimension2DDouble(10.0, 6.0);
    }

    public void drawU(UGraphic uGraphic, int n, Dimension2D dimension2D) {
        if (n != 0) {
            return;
        }
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.getColorIfValid("#AAAAAA")));
        double d = dimension2D.getHeight() / 2.0;
        if (this.separator == '=') {
            d -= 1.0;
        }
        ElementLine.drawLine(uGraphic, 0.0, d, dimension2D.getWidth(), this.separator);
    }

    private static void drawLine(UGraphic uGraphic, double d, double d2, double d3, char c) {
        if (c == '=') {
            uGraphic.apply(new UStroke()).apply(new UTranslate(d, d2)).draw(new ULine(d3, 0.0));
            uGraphic.apply(new UStroke()).apply(new UTranslate(d, d2 + 2.0)).draw(new ULine(d3, 0.0));
        } else if (c == '.') {
            uGraphic.apply(new UStroke(1.0, 2.0, 1.0)).apply(new UTranslate(d, d2)).draw(new ULine(d3, 0.0));
        } else if (c == '-') {
            uGraphic.apply(new UStroke()).apply(new UTranslate(d, d2)).draw(new ULine(d3, 0.0));
        } else {
            uGraphic.apply(new UStroke(1.5)).apply(new UTranslate(d, d2)).draw(new ULine(d3, 0.0));
        }
    }
}

