### -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::Morph::SMOR.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: morphological analysis via Gfsm automata, for use with SMOR-style transducers (German, e.g. zmorge)
## + zmorge transducers and lexica available in SFST format https://pub.cl.uzh.ch/users/sennrich/zmorge/
## + grammar and build rules availble from https://github.com/rsennrich/SMORLemma

##==============================================================================
## Package: Analyzer::Morph
##==============================================================================
package DTA::CAB::Analyzer::Morph::SMOR;
use DTA::CAB::Analyzer::Morph::Helsinki::DE;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Morph::Helsinki::DE);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Automaton::Gfsm
sub new {
  my $that = shift;
  my $aut = $that->SUPER::new(
			      ##-- defaults

			      ##-- analysis selection
			      label => 'morph',
			      wantAnalysisLo => 0,
			      wantAnalysisLemma => 0, ##-- default=0
			      tolower => 0,
			      capsFallback => 1,

			      ##-- verbosity
			      check_symbols => 0,

			      ##-- user args
			      @_
			     );
  return $aut;
}

1; ##-- be happy

__END__
##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::Morph::SMOR - morphological analysis via Gfsm automata, for SMOR-style transducers (e.g. Zmorge)

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::Morph::SMOR;
 
 $morph = DTA::CAB::Analyzer::Morph::SMOR->new(%args);
 $morph->analyze($tok);

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Analyzer::Morph::SMOR
is a subclass of
L<DTA::CAB::Analyzer::Morph::Helsinki::DE|DTA::CAB::Analyzer::Morph::Helsinki::DE>
suitable for use with SMOR-style transducers, including
L<zmorge|https://pub.cl.uzh.ch/users/sennrich/zmorge/> transducers as produced
by the L<SMORLemma|https://github.com/rsennrich/SMORLemma> grammar.

To produce a GFSM transducer (C<zmorge.gfst>) and vocabulary (C<zmorge.lab>) suitable for use with this module from one of the
binary SFST-format transducers available from L<https://pub.cl.uzh.ch/users/sennrich/zmorge/>,
do something like the following (in debian at least):

 sudo apt-get install sfst unzip wget sed gawk
 wget https://pub.cl.uzh.ch/users/sennrich/zmorge/transducers/zmorge-20150315-smor_newlemma.a.zip
 unzip zmorge-20150315-smor_newlemma.a.zip
 fst-print zmorge-20150315-smor_newlemma.a | sed 's/ /_/g;' > zmorge.tfst
 cat zmorge.tfst \
   | awk -F$'\t' '{ if (NF >= 4) { print $3 "\n" $4 } }' \
   | sed 's/^<>$//;' \
   | sort -u \
   | sed 's/^$/<>/;' \
   | awk '{print $1 "\t" NR-1}' \
   > zmorge.lab
  gfsmcompile -z0 -l zmorge.lab zmorge.tfst | gfsminvert -z0 | gfsmarcsort -l -F zmorge.gfst

You can then test the compiled transducer with this module by calling e.g.:

 dta-cab-analyze.perl -ac=Morph::SMOR -ao=fstFile=zmorge.gfst -ao=labFile=zmorge.lab -fc=text -w Vermittlungsgespräche

which should produce something like the following output:

 Vermittlungsgespräche
 	+[morph] Vermittlungsgespräch[_NN]=Vermittl[<~>]ungs[<#>]gespräch[<+NN>][<Neut>][<Acc>][<Pl>] <0>
 	+[morph] Vermittlungsgespräch[_NN]=Vermittl[<~>]ungs[<#>]gespräch[<+NN>][<Neut>][<Dat>][<Sg>][<Old>] <0>
 	+[morph] Vermittlungsgespräch[_NN]=Vermittl[<~>]ungs[<#>]gespräch[<+NN>][<Neut>][<Gen>][<Pl>] <0>
 	+[morph] Vermittlungsgespräch[_NN]=Vermittl[<~>]ungs[<#>]gespräch[<+NN>][<Neut>][<Nom>][<Pl>] <0>
 	+[morph] Vermittlungsgespräch[_NN]=Vermittlung[<->]s[<#>]gespräch[<+NN>][<Neut>][<Acc>][<Pl>] <0>
 	+[morph] Vermittlungsgespräch[_NN]=Vermittlung[<->]s[<#>]gespräch[<+NN>][<Neut>][<Dat>][<Sg>][<Old>] <0>
 	+[morph] Vermittlungsgespräch[_NN]=Vermittlung[<->]s[<#>]gespräch[<+NN>][<Neut>][<Gen>][<Pl>] <0>
 	+[morph] Vermittlungsgespräch[_NN]=Vermittlung[<->]s[<#>]gespräch[<+NN>][<Neut>][<Nom>][<Pl>] <0>


=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2021 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
