# -*- Mode: CPerl -*-

$TEST_DIR = './t';
#use lib qw(../blib/lib ../blib/arch); $TEST_DIR = '.'; # for debugging

use DDC::XS;

# load common subs
do "$TEST_DIR/common.plt"
  or die("could not load $TEST_DIR/common.plt");

plan(test => 18);

##-- 1..3: sample, sort
my ($q);
$q = DDC::XS->parse('count(foo) #sample[10] #by[textClass~s/::.*$//,date/10] #asc_key');
isok("qcount:parse", $q);
isok("qcount:sample", $q->getSample==10);
isok("qcount:sort", $q->getSort==DDC::XS::LessByCountKey);

##-- 4..11: keys
my $keys = $q->getKeys;
isok("qcount:keys:byfile", $keys->CanCountByFile);
isok("qcount:keys[0]:src:label", $keys->getExprs->[0]->getSrc->getLabel eq 'textClass');
isok("qcount:keys[0]:pattern",   $keys->getExprs->[0]->getPattern eq '::.*$');
isok("qcount:keys[0]:replacement", $keys->getExprs->[0]->getReplacement eq '');
isok("qcount:keys[0]:modifiers", $keys->getExprs->[0]->getModifiers eq '');
isok("qcount:keys[0]:!isGlobal", !$keys->getExprs->[0]->getIsGlobal);
isok("qcount:keys[1]:label",     $keys->getExprs->[1]->getLabel eq 'date');
isok("qcount:keys[1]:slice",     $keys->getExprs->[1]->getSlice == 10);

##-- reference-counting woes:
##   + just incrementing refcounts when setting child objects isn't enough:
##     we really need to ensure ensure that each descendant has AT LEAST as many references
##     as each of its ancestors...
my $key = DDC::XS::CQCountKeyExprConstant->new('0');
$keys->PushKey($key);
isok("qcount:PushKey:refcnt",  $key && $key->refcnt==$keys->refcnt+1);
undef $key; ##-- segfaults if refcnt failed

##-- 13..18: context-count
$q = DDC::XS->parse('count($l=foo =1) #by[$w =1] #desc_count');
isok("qcount:ctx:parse", $q);
isok("qcount:ctx:!countbyfile", !$q->getKeys->CanCountByFile);
isok("qcount:ctx:HasMatchId:", $q->HasMatchId);
$key = $q->getKeys->getExprs->[0];
isok("qcount:ctx:key:IndexName", $key->getIndexName eq 'w');
isok("qcount:ctx:key:MatchId", $key->getMatchId == 1);
isok("qcount:ctx:key:Offset", $key->getOffset == 0);

print "\n";

