# Before 'make install' is performed this script should be runnable with
# 'make test'. After 'make install' it should work as 'perl AnyEvent-ClickHouse.t'

#########################

use strict;
use warnings;

use Test::More tests => 3;
BEGIN { use_ok('AnyEvent::ClickHouse') };

use Test::HTTP::AnyEvent::Server;
my $server = Test::HTTP::AnyEvent::Server->new(
    custom_handler => sub {
    	my ($response) = @_;
    	$response->content('Ok.');
    	return 1;
    }
);

my $cv = AnyEvent->condvar;

clickhouse_select({
	hast=>'127.0.0.1',
	port=>$server->{port}
}, "select 1",
sub {
    my $r = shift;
    is $r, 'Ok.';
    $cv->send;
},
sub {
    is 0, 1;
    $cv->send;	
}
);

clickhouse_select_array({
	hast=>'127.0.0.1',
	port=>$server->{port}
}, "select 1",
sub {
    my $r = shift;
    is $r->[0]->[0], 'Ok.';
    $cv->send;
},
sub {
    is 0, 1;
    $cv->send;	
}
);

$cv->recv;

