package App::bif::update::identity;
use strict;
use warnings;
use Bif::Mo;

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $dbw  = $self->dbw;
    my $info = $self->get_node( $opts->{id} );

    return $self->err( 'IdentityNotFound', "identity not found: $opts->{id}" )
      unless $info;

    $dbw->txn(
        sub {
            $self->pause_work;
            my $start = time;

            if ( $opts->{reply} ) {
                my $uinfo =
                  $self->get_change( $opts->{reply}, $info->{first_change_id} );
                $opts->{parent_uid} = $uinfo->{id};
            }
            else {
                $opts->{parent_uid} = $info->{first_change_id};
            }

            $opts->{message} ||= $self->prompt_edit( opts => $self );

            $opts->{change_id} =
              $self->new_change( parent_id => $opts->{parent_uid}, );

            $dbw->xdo(
                insert_into => 'func_update_identity',
                values      => {
                    change_id => $opts->{change_id},
                    id        => $info->{id},
                    name      => $opts->{name},
                    shortname => $opts->{shortname},
                },
            );

            $self->save_new_work(
                change_id => $opts->{change_id},
                node_id   => $info->{id},
                start     => $start,
                stop      => time,
                bill      => 1,
            );

            $self->end_change(
                id               => $opts->{change_id},
                message          => $opts->{message},
                action_format    => "update identity %s",
                action_node_id_1 => $info->{id},
            );

            $self->resume_work;
        }
    );

    return $self->ok('ChangeIdentity');
}

1;
__END__

=head1 NAME

=for bif-doc #modify

bif-update-identity - update or comment an identity

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif update identity ID [OPTIONS...]

=head1 DESCRIPTION

The "bif update identity" command adds a comment to an identity,
possibly setting a new name at the same time.

=head1 ARGUMENTS & OPTIONS

=over

=item ID

An identity ID, required.

=item --name, -n

The new name for the identity.

=item --message, -m

The message describing this change in detail.

=item --shortname, -s

The shortname (initials) to be shown in some outputs

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

