use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    isa_ok exception { bif(qw/drop hub /) }, 'OptArgs::Usage';
    isa_ok exception { bif(qw/drop hub nohub/) },
      'Bif::Error::UserRepoNotFound';

    bif(qw/init/);
    isa_ok exception { bif(qw/drop hub hub/) }, 'Bif::Error::HubNotFound';

    bif(qw/new hub name title/);
    isa_ok bif(qw/drop hub name/),    'Bif::OK::DropNoForce';
    isa_ok bif(qw/drop hub name -f/), 'Bif::OK::DropHub';
    isa_ok exception { bif(qw/show hub name/) }, 'Bif::Error::HubNotFound';

    bifcheck;
};

done_testing();
