CREATE TABLE identity_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    identity_id INTEGER NOT NULL,
    shortname VARCHAR,
    new INTEGER,
    FOREIGN KEY(id) REFERENCES deltas(id) ON DELETE CASCADE,
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(identity_id) REFERENCES identities(id) ON DELETE CASCADE
);

CREATE TRIGGER
    identity_deltas_ai_1
AFTER INSERT ON
    identity_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.identity_id,
        NEW.shortname
    );

    UPDATE
        changes
    SET
        ucount = ucount + 1
    WHERE
        id = NEW.change_id
    ;


    INSERT OR IGNORE INTO
        identities_tomerge(identity_id) VALUES (NEW.identity_id);

    UPDATE
        identities_tomerge
    SET
        shortname = shortname + (NEW.shortname IS NOT NULL)
    WHERE
        identity_id = NEW.identity_id
    ;

    INSERT INTO
        entity_related_changes(
            entity_id,
            change_id
        )
    VALUES (
        NEW.identity_id,
        NEW.change_id
    );

    UPDATE
        change_nodes
    SET
        hub_change = hub_change + 1,
        project_change = project_change + 1
    WHERE
        change_id = NEW.change_id AND node_id = NEW.identity_id
    ;

END;
