CREATE TABLE issues_tomerge(
    issue_id INTEGER NOT NULL UNIQUE,
    title INTEGER DEFAULT 0,
    issue_status_id INTEGER DEFAULT 0,
    resolve INTEGER,
    FOREIGN KEY(issue_id) REFERENCES issues(id) ON DELETE CASCADE
);


CREATE TRIGGER
    issues_tomerge_bu_1
BEFORE UPDATE OF
    resolve
ON
    issues_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.title != 0
BEGIN

    SELECT debug(
        OLD.issue_id
    );

    UPDATE
        issues
    SET
        title = (
            SELECT
                issue_deltas.title
            FROM
                issue_deltas
            INNER JOIN
                changes
            ON
                changes.id = issue_deltas.change_id
            WHERE
                issue_deltas.issue_id = OLD.issue_id AND
                issue_deltas.title IS NOT NULL
            ORDER BY
                changes.mtime DESC,
                changes.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.issue_id
    ;

END;


CREATE TRIGGER
    issues_tomerge_bu_0
BEFORE UPDATE OF
    resolve
ON
    issues_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.issue_status_id != 0
BEGIN

    SELECT debug(
        OLD.issue_id
    );

    UPDATE
        issues
    SET
        issue_status_id = (
            SELECT
                id.issue_status_id
            FROM
                issue_deltas id
            INNER JOIN
                changes c
            ON
                c.id = id.change_id
            WHERE
                id.issue_id = OLD.issue_id AND
                id.issue_status_id IS NOT NULL
            ORDER BY
                c.mtime DESC,
                c.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.issue_id
    ;

END;


CREATE TRIGGER
    issues_tomerge_au_1
AFTER UPDATE OF
    resolve
ON
    issues_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1
BEGIN

    SELECT debug(
        OLD.issue_id
    );

    DELETE FROM
        issues_tomerge
    WHERE
        issue_id = OLD.issue_id
    ;

END;
