/*
    This is an internal function that doesn't create its own
    topic_delta, which is left up to whatever the calling function is.
*/
CREATE TABLE func_new_topic(
    change_id INTEGER,
    id INTEGER NOT NULL DEFAULT (nextval('topics')),
    parent_id INTEGER,
    kind VARCHAR,
    name VARCHAR NOT NULL,
    uuid VARCHAR(40)
);


CREATE TRIGGER
    func_new_topic_bi_1
BEFORE INSERT ON
    func_new_topic
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.id,
        NEW.parent_id,
        NEW.name,
        NEW.kind,
        NEW.uuid
    );

    INSERT INTO
        topics(
            id,
            parent_id,
            first_change_id,
            last_change_id,
            name,
            path,
            kind,
            ctime,
            ctimetz,
            mtime,
            mtimetz,
            lang,
            uuid
        )
    SELECT
        NEW.id,
        NEW.parent_id,
        NEW.change_id,
        NEW.change_id,
        NEW.name,
        NEW.kind || '-' || NEW.id, -- just to make the insertion unique
        NEW.kind,
        c.mtime,
        c.mtimetz,
        c.mtime,
        c.mtimetz,
        c.lang,
        sha1_hex(c.yaml)
    FROM
        changes c
    WHERE
        c.id = NEW.change_id
    ;


    SELECT
        CASE WHEN
            NEW.uuid IS NULL OR
            (NEW.uuid IS NOT NULL AND t.uuid = NEW.uuid)
        THEN
            RAISE(IGNORE)
        ELSE
            RAISE(ABORT, 'Bif::Err::TopicUUIDMismatch')
        END
    FROM
        topics t
    WHERE
        t.id = NEW.id
    ;

END;
