CREATE TABLE func_import_update_identity(
    uuid VARCHAR(40) NOT NULL,
    name VARCHAR,
    shortname VARCHAR,
    contact_uuid VARCHAR(40),
    default_contact_method_uuid VARCHAR(40)
);

CREATE TRIGGER
    func_import_update_identity_bi_1
BEFORE INSERT ON
    func_import_update_identity
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.name,
        NEW.shortname,
        NEW.contact_uuid,
        NEw.default_contact_method_uuid
    );

    INSERT INTO
        func_update_identity(
            change_id,
            id,
            name,
            shortname,
            contact_id,
            default_contact_method_id
        )
    SELECT
        currval('changes'),
        i.id,
        NEW.name,
        NEW.shortname,
        con.id,
        dcm.id
    FROM
        topics i
    LEFT JOIN
        topics con
    ON
        con.uuid = NEW.contact_uuid
    LEFT JOIN
        topics dcm
    ON
        dcm.uuid = NEW.default_contact_method_uuid
    WHERE
        i.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
