CREATE TABLE func_import_new_hub(
    location VARCHAR NOT NULL,
    uuid VARCHAR NOT NULL
);

CREATE TRIGGER
    func_import_new_hub_bi_1
BEFORE INSERT ON
    func_import_new_hub
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.location,
        NEW.uuid
    );

    INSERT INTO
        func_new_hub(
            change_id,
            id,
            location
        )
    SELECT
        currval('changes'),
        h.id,
        NEW.location
    FROM
        topics h
    WHERE
        h.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
