CREATE TABLE func_import_task_status(
    project_uuid VARCHAR(40) NOT NULL,
    status VARCHAR(40) NOT NULL,
    rank INTEGER NOT NULL,
    def INTEGER,
    uuid VARCHAR(40) NOT NULL
);


CREATE TRIGGER
    func_import_task_status_bi_1
BEFORE INSERT ON
    func_import_task_status
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.project_uuid,
        NEW.status,
        NEW.rank,
        NEW.def,
        NEW.uuid
    );

    INSERT INTO
        func_new_task_status(
            change_id,
            id,
            project_id,
            status,
            rank,
            def,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('topics'),
        p.id,
        NEW.status,
        NEW.rank,
        NEW.def,
        NEW.uuid
    FROM
        topics p
    WHERE
        p.uuid = NEW.project_uuid
    ;

    SELECT RAISE(IGNORE);
END;
