CREATE TABLE func_new_identity_contact_method(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    identity_id INTEGER NOT NULL,
    method VARCHAR NOT NULL,
    mvalue VARCHAR NOT NULL,
    uuid VARCHAR(40)
);


CREATE TRIGGER
    func_new_identity_contact_method_bi_1
BEFORE INSERT ON
    func_new_identity_contact_method
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.id,
        NEW.identity_id,
        NEW.method,
        NEW.mvalue,
        NEW.uuid
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_identity_contact_method' || x'0A'
                || '  identity_uuid: ' || i.uuid || x'0A'
                || '  method: ' || NEW.method || x'0A'
                ||
                    CASE WHEN
                        NEW.mvalue IS NULL
                    THEN
                        '  mvalue: ~' || x'0A'
                    WHEN
                        NEW.mvalue = '-'
                    THEN
                        '  mvalue: ''-''' || x'0A'
                    WHEN
                        instr(NEW.mvalue, x'0A') OR
                        instr(NEW.mvalue, '\\')
                    THEN
                        '  mvalue: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.mvalue, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.mvalue, ' ') OR
                        NEW.mvalue = '' -- not at all sufficient
                    THEN
                        '  mvalue: ''' || NEW.mvalue || '''' || x'0A'
                    ELSE
                        '  mvalue: ' || NEW.mvalue || x'0A'
                    END
            FROM
                topics i
            WHERE
                i.id = NEW.identity_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_identity_contact_method'
    );


    INSERT INTO
        func_new_topic2(
            change_id,
            id,
            kind,
            uuid
        )
    VALUES(
        NEW.change_id,
        NEW.id,
        'entity_contact_method',
        NEW.uuid
    );

    INSERT INTO entity_contact_methods(
        id,
        entity_id,
        method,
        mvalue
    )
    VALUES(
        NEW.id,
        NEW.identity_id,
        NEW.method,
        NEW.mvalue
    );

    INSERT INTO
        entity_contact_method_deltas(
            id,
            change_id,
            entity_contact_method_id,
            new,
            method,
            mvalue
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        1,
        NEW.method,
        NEW.mvalue
    );


    SELECT RAISE(IGNORE);
END;

