CREATE TABLE func_import_identity_contact_method(
    identity_uuid VARCHAR(40) NOT NULL,
    method VARCHAR NOT NULL,
    mvalue VARCHAR NOT NULL,
    uuid VARCHAR(40) NOT NULL
);


CREATE TRIGGER
    func_import_identity_contact_method_bi_1
BEFORE INSERT ON
    func_import_identity_contact_method
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.identity_uuid,
        NEW.method,
        NEW.mvalue,
        NEW.uuid
    );

    INSERT INTO
        func_new_identity_contact_method(
            change_id,
            id,
            identity_id,
            method,
            mvalue,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('topics'),
        i.id,
        NEW.method,
        NEW.mvalue,
        NEW.uuid
    FROM
        topics i
    WHERE
        i.uuid = NEW.identity_uuid
    ;

    SELECT RAISE(IGNORE);
END;
