CREATE TABLE func_update_issue(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    issue_status_id INTEGER,
    title VARCHAR
);

CREATE TRIGGER
    func_update_issue_bi_1
BEFORE INSERT ON
    func_update_issue
FOR EACH ROW BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.issue_status_id,
        NEW.title
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: update_issue' || x'0A'
                || '  issue_status_uuid: ' || COALESCE(s.uuid,'~') || x'0A'
                ||
                    CASE WHEN
                        NEW.title IS NULL
                    THEN
                        '  title: ~' || x'0A'
                    WHEN
                        NEW.title = '-'
                    THEN
                        '  title: ''-''' || x'0A'
                    WHEN
                        instr(NEW.title, x'0A') OR
                        instr(NEW.title, '\\')
                    THEN
                        '  title: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.title, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.title, ' ') OR
                        NEW.title = '' -- not at all sufficient
                    THEN
                        '  title: ''' || NEW.title || '''' || x'0A'
                    ELSE
                        '  title: ' || NEW.title || x'0A'
                    END
                || '  uuid: ' || i.uuid || x'0A'
            FROM
                topics i
            LEFT JOIN
                topics s
            ON
                s.id = NEW.issue_status_id
            WHERE
                i.id = NEW.id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'update_issue'
    );

    INSERT INTO
        issue_deltas(
            id,
            change_id,
            issue_id,
            issue_status_id,
            title
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.issue_status_id,
        NEW.title
    );

    SELECT RAISE(IGNORE);

END;
