CREATE TABLE func_new_project(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    parent_id INTEGER,
    name VARCHAR(40),
    title VARCHAR(1024) NOT NULL DEFAULT '',
    uuid VARCHAR(40),
    local INTEGER DEFAULT 0,
    work_delta INTEGER
);

CREATE TRIGGER
    func_new_project_bi_1
BEFORE INSERT ON
    func_new_project
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.parent_id,
        NEW.name,
        NEW.title,
        NEW.local,
        NEW.uuid,
        NEW.work_delta
    );


    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_project' || x'0A'
                || CASE WHEN
                    instr(NEW.name, ' ')
                THEN
                    '  name: ''' || NEW.name || '''' || x'0A'
                ELSE
                    '  name: ' || NEW.name || x'0A'
                END
                || '  parent_uuid: ' || COALESCE(p.uuid, '~') || x'0A'
                ||
                    CASE WHEN
                        NEW.title IS NULL
                    THEN
                        '  title: ~' || x'0A'
                    WHEN
                        NEW.title = '-'
                    THEN
                        '  title: ''-''' || x'0A'
                    WHEN
                        instr(NEW.title, x'0A') OR
                        instr(NEW.title, '\\')
                    THEN
                        '  title: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.title, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.title, ' ') OR
                        NEW.title = '' -- not at all sufficient
                    THEN
                        '  title: ''' || NEW.title || '''' || x'0A'
                    ELSE
                        '  title: ' || NEW.title || x'0A'
                    END
                || '  work_delta: ' || COALESCE(NEW.work_delta, '~')
                    || x'0A'
            FROM
                (SELECT 1)
            LEFT JOIN
                topics p
            ON
                p.id = NEW.parent_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO func_new_topic2(
        id,
        change_id,
        kind,
        uuid
    )
    VALUES(
        NEW.id,
        NEW.change_id,
        'project',
        NEW.uuid
    );

    /*
        Make the name unique at this point in time, so that projects
        with names the same as current projects don't conflict due to
        the projects.path UNIQUE clause.
    */
    INSERT INTO
        projects(
            id,
            parent_id,
            hub_id,
            name,
            path,
            title,
            local
        )
    SELECT
        NEW.id,
        NEW.parent_id,
        pp.hub_id,
        'bif-project-' || NEW.id,
        'bif-project-' || NEW.id,
        NEW.title,
        NEW.local
    FROM
        (SELECT 1)
    LEFT JOIN
        projects pp
    ON
        pp.id = NEW.parent_id
    ;


    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_project'
    );


    INSERT INTO
        project_deltas(
            id,
            change_id,
            project_id,
            parent_id,
            new,
            name,
            title
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.parent_id,
        1,
        NEW.name,
        NEW.title
    );

    INSERT INTO
        work_deltas(
            id,
            change_id,
            topic_id,
            delta
        )
    SELECT
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.work_delta

    WHERE
        NEW.work_delta IS NOT NULL
    ;


    SELECT RAISE(IGNORE);
END;
