CREATE TABLE func_import_hub_delta(
    uuid VARCHAR(40) NOT NULL,
    name VARCHAR(128),
    title VARCHAR
);

CREATE TRIGGER
    func_import_hub_delta_bi_1
BEFORE INSERT ON
    func_import_hub_delta
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.name,
        NEW.title
    );

    INSERT INTO
        func_update_hub(
            change_id,
            id,
            name,
            title
        )
    SELECT
        currval('changes'),
        h.id,
        NEW.name,
        NEW.title
    FROM
        topics h
    WHERE
        h.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
