use ExtUtils::MakeMaker;

my %options = %{ {
    NAME          => 'cppAdaptive2',
    VERSION_FROM  => 'lib/cppAdaptive2.pm',
    ABSTRACT_FROM => 'lib/cppAdaptive2.pm',
    'LIBS'        => ['-lstdc++'],
    'TYPEMAPS'    => ['CPP.map'],
    'INC'         => '-I./src',
    CONFIGURE     => \&configure,
    'CCFLAGS'     => '-std=c++11 -w',
} };

WriteMakefile(%options);

# Remove the Makefile dependency. Causes problems on a few systems.
sub MY::makefile {''}

sub configure {
    if ( $^O =~ /MSWin/sm ) {
        return { CC => 'g++  -s -O2 -DWIN32 -DWIN64 -DCONSERVATIVE -D__USE_MINGW_ANSI_STDIO -DPERL_TEXTMODE_SCRIPTS -DPERL_IMPLICIT_CONTEXT -DPERL_IMPLICIT_SYS -DUSE_PERLIO -fwrapv -fno-strict-aliasing -mms-bitfields  -xc++', };
    }
    else {
        return { CC => 'g++ -fwrapv -fno-strict-aliasing -pipe -fstack-protector-strong -I/usr/local/include -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 -xc++', };
    }
}
