#	Copyright Infomation
#=========================================================#
#	Module	:	Nile::Base
#	Author		:	Dr. Ahmed Amin Elsheshtawy, Ph.D.
#	Website	:	https://github.com/mewsoft/Nile, http://www.mewsoft.com
#	Email		:	mewsoft@cpan.org, support@mewsoft.com
#	Copyrights (c) 2014-2015 Mewsoft Corp. All rights reserved.
#=========================================================#
package Nile::Base;

our $VERSION = '0.13';

=pod

=encoding utf8

=head1 NAME

Nile::Base - Base class for the Nile framework.

=head1 SYNOPSIS
		
	package Nile::Plugin::Home::Home;

	use Nile::Base;

	sub home  : GET Action {
		my ($self) = @_;
	}
	
	1;

=head1 DESCRIPTION

Nile::Base - Base class for the Nile framework.

=cut

use Moose;
#use MooseX::Declare;
use MooseX::MethodAttributes;
use utf8;
use Import::Into;
use Module::Runtime qw(use_module);

use Nile::Say;
use Nile::Declare ('method' => 'method', 'function' => 'function', 'invocant'=>'$this', 'inject'=>'my ($me) = $this->me;');

our @EXPORT_MODULES = (
		#strict => [],
		#warnings => [],
		Moose => [],
		utf8 => [],
		'Nile::Say' => [],
		'Nile::Declare' => ['method' => 'method', 'function' => 'function', 'invocant'=>'$self', 'inject'=>'my ($me) = $self->me;'],
		#'MooseX::Declare' => [],
		'MooseX::MethodAttributes' => [],
	);

sub import {
my ($class, %args) = @_;
	my $caller = caller;
	my @modules = @EXPORT_MODULES;
    while (@modules) {
        my $module = shift @modules;
        my $imports = ref $modules[0] eq 'ARRAY' ? shift @modules : [];
        use_module($module)->import::into($caller, @{$imports});
    }
}

=pod

=head1 Bugs

This project is available on github at L<https://github.com/mewsoft/Nile>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Nile>.

=head1 SOURCE

Source repository is at L<https://github.com/mewsoft/Nile>.

=head1 AUTHOR

Ahmed Amin Elsheshtawy,  احمد امين الششتاوى <mewsoft@cpan.org>
Website: http://www.mewsoft.com

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2014-2015 by Dr. Ahmed Amin Elsheshtawy احمد امين الششتاوى mewsoft@cpan.org, support@mewsoft.com,
L<https://github.com/mewsoft/Nile>, L<http://www.mewsoft.com>

This library is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=cut

1;
