use 5.008;
use strict;

use lib 'inc';
require Module::Build::PdfDocument;

our $VERSION = '0.09';

# Create build script
Module::Build::PdfDocument::wxpdf_builderclass()->new(
	module_name        => 'Wx::PdfDocument',
	license            => 'perl',
	dist_author        => q{Mark Wardell <mwardell@cpan.org>},
	dist_version_from  => 'lib/Wx/PdfDocument.pm',
	configure_requires => {
		'perl'          => '5.008',
		'Module::Build' => '0.36',
	},
	build_requires => {
        'Archive::Extract' => 0,
        'LWP::UserAgent'   => 0,
		'Test::More'       => 0,
		'ExtUtils::XSpp'   => '0.1602',
        'Text::Patch'      => '1.8',
	},
	requires => {
		'perl'             => '5.008',
        'Alien::wxWidgets' => '0.27',
		'Wx'               => '0.9909',
        'Class::Accessor'  => '0.34',
	},
	needs_compiler => 0, # We will be doing our own XS compilation
	add_to_cleanup => [
		'PdfDocument.c',
		'PdfDocument.o',
		'PdfDocument.obj',
		'PdfDocument.bs',
		'PdfDocument.def',
		'PdfDocument_def.old',
		'blib',
		'*.dll',
		'*.pdb',
		'*.obj',
		'*.a',
		'*.so',
        Module::Build::PdfDocument::wxpdf_libdirectory(),
        'cpp/ovl_const.h',
        'cpp/ovl_const.cpp',
        'pdfbsuccess.scs',
	],
	meta_merge => {
		resources => {
			homepage   => 'http://code.google.com/p/wxperl-pdfdocument/wiki/Home',
			repository => 'http://wxperl-pdfdocument.googlecode.com/svn/',
		},
		no_index => {
			directory => [qw<src cpp inc myinc msw patches demo lib/Wx/DemoModules>],
            # pause hates our package style
            package => [ qw( Wx::PdfLayerGroup Wx::PdfOcg Wx::PdfColour Wx::PdfInfo
                             Wx::PdfLineStyle Wx::PdfShape Wx::PdfFont Wx::PdfFontDescription
                             Wx::PdfFontManager Wx::PdfBarCodeCreator Wx::PdfLayer
                             Wx::PdfLayerMembership Wx::PdfDC Wx::PdfLink Wx::PdfPageLink
                             Wx::PdfPrinter Wx::PdfPrintData Wx::PdfPrintPreview
                             Wx::PdfPrintPreviewImpl Wx::PdfPageSetupDialog Wx::PdfPrintDialog
                             Wx::PlPdfDocument ) ],
		},
	},
	dist_abstract      => 'PDF output for wxWidgets',

)->create_build_script();
