#!/usr/bin/env perl

use strict;
use warnings;

use App::ClusterSSH;
use Test::Exception;
use Test::More tests => 3;

throws_ok {
  App::ClusterSSH->new;
} qr/\QAttribute (command) is required\E/,
'creating an instance of App::ClusterSSH without a command fails';

lives_ok {
   App::ClusterSSH->new( command => 'ls' );
} 'creating an instance of App::ClusterSSH lives';

is( App::ClusterSSH->new( command => 'ls' )->config_file,
    "$ENV{HOME}/.app-clusterssh.yml",
    'default value of config_file points to .app-clusterssh.yml in $HOME'
);
