#############################################################################
## Name:        make_exp_list.pl
## Purpose:     builds lib/Wx/_Exp.pm (export lists for Wx and Wx::Event)
## Author:      Mattia Barbon
## Modified by:
## Created:     29/10/2000
## RCS-ID:      
## Copyright:   (c) 2000 Mattia Barbon
## Licence:     This program is free software; you can redistribute it and/or
##              modify it under the same terms as Perl itself
#############################################################################

#
# @EXPORT_OK and %EXPORT_TAGS for Wx.pm (constants in Constant.xs)
#

my $ext = shift @ARGV;

my $parser;
my %packages;
my $tag;
my $package;

foreach my $i ( @ARGV ) {
  open IN, '< ' . $i or die "unable to open '$i'";
  $tag = '';
  $package = '';
  $parser = undef;

  while( <IN> ) {
    m/^\W+?\!(\w+):\s*(.*)$/ && do {
      my( $t, $v ) = ( $1, $2 );

      if( $t eq 'parser' ) { $parser = eval "$v"; die if $@ }
      if( $t eq 'package' ) { $package = $v }
      if( $t eq 'tag' ) { $tag = $v }
      next;
    };
    next unless $parser;

    my @values = $parser->( $_ );
    length( $values[0] ) || next;

    foreach ( split '\s+', $values[1] . ' ' . $tag ) {
      next if $_ =~ /^\s*$/;

      push @{ $packages{$package}{tags}{$_} }, $values[0];
    }

    push @{ $packages{$package}{exp_ok} }, $values[0];
#    print "$values[0] => $values[1]\n";
  }
}

close IN;

#
# write export file
#

open OUT, '> '. $ext || die "unable to open file '$ext'";

binmode OUT; # Perl 5.004 on Unix complains for CR

print OUT <<EOT;
#############################################################################
## Name:        _Exp.pm
## Purpose:     export lists (AUTOGENERATED, DO NOT EDIT)
## Author:      Mattia Barbon
## Modified by:
## Created:     29/10/2000
## RCS-ID:      
## Copyright:   (c) 2000-2001 Mattia Barbon
## Licence:     This program is free software; you can redistribute it and/or
##              modify it under the same terms as Perl itself
#############################################################################
EOT

foreach my $package ( sort keys %packages ) {
print OUT <<EOT;

package ${package};

push \@EXPORT_OK, qw(@{$packages{$package}{exp_ok}});

\$EXPORT_TAGS{'everything'} = [ \@EXPORT_OK ];

EOT

  foreach my $tag ( sort keys %{ $packages{$package}{tags} } ) {
    print OUT <<EOT;
\$EXPORT_TAGS{'$tag'} = [ qw(@{ $packages{$package}{tags}{$tag} }) ];
EOT
  }
}

print OUT <<EOT;
1;

# Local variables: #
# mode: cperl #
# End: #
EOT

# Local variables: #
# mode: cperl #
# End: #

