use v6;
use Semi-xml;
use TMap::Role;

package TMap:ver<0.2.0> {

  role Association {

    # Topicmap parent
    #
    has $.tm-parent;
    has $.type;
    has @.scopes;

    #---------------------------------------------------------------------------
    # Initialize variant object
    #
    method initialize ( $topicmap where $topicmap.name eq 'topicMap' ) {

      $!tm-parent = $topicmap;
      self.check-item-identifiers;
      self.set-reifier($topicmap);

      for self.nodes -> $a-node {
        if $a-node ~~ XML::Element {
          given $a-node.name {

            when 'scope' {
              my @trefs = self.get-topic-references($a-node);

              for @trefs -> $tref {
                my $scope = $topicmap.get-topic-from-id($tref);
                if ?$scope {
  say "Occurrence scope: ", $scope.attribs<id>;

                  # Store id as string. Later when checked get object of
                  # reference
                  #
                  @!scopes.push($scope);
                }
              }
            }

            # Get the type of this occurence
            #
            when 'type' {
              my @trefs = self.get-topic-references($a-node);
              my $occ-type = $topicmap.get-topic-from-id(@trefs[0]);
  say "Occurrence type: ", $occ-type.attribs<id> if ?$occ-type;

              # Store id as string. Later when checked get object of reference
              #
              $!type = $occ-type if ?$occ-type;
            }
            
            when 'role' {
              $a-node does TMap::Role;
              my TMap::Role $role := $a-node;
              $role.initialize(self);
            }
          }
        }
      }
    }

    #---------------------------------------------------------------------------
    # Some getters
    #
    multi method get ( 'parent' ) { return $!tm-parent; }
    multi method get ( 'type' ) { return $!type; }
  }
}
