use Test::More tests => 16;
use strict;
use warnings;

use Sys::Hostname;
use Math::UInt64 qw/uint64/;

my $unique = hostname . "-$^O-$^V-$$"; #hostname-os-perlversion-PID
my $exchange = "nr_test_x-$unique";
my $routekey = "nr_test_q-$unique";

my $dtag=1;
my $host = $ENV{'MQHOST'} || "dev.rabbitmq.com";

use_ok('Net::AMQP::RabbitMQ');

my $mq = Net::AMQP::RabbitMQ->new();
ok($mq);

eval { $mq->connect($host, { user => "guest", password => "guest" }); };
is($@, '', "connect");
eval { $mq->channel_open(1); };
is($@, '', "channel_open");

# Re-establish the exchange if it wasn't created in 001
# or in 002
eval { $mq->exchange_declare(1, $exchange, { exchange_type => "direct", passive => 0, durable => 1, auto_delete => 0, internal => 0 }); };
is($@, '', "exchange_declare");

my $queuename = '';
eval { $queuename = $mq->queue_declare(1, '', { passive => 0, durable => 1, exclusive => 0, auto_delete => 1 }); };
is($@, '', "queue_declare");
isnt($queuename, '', "queue_declare -> private name");
eval { $mq->queue_bind(1, $queuename, $exchange, $routekey); };
is($@, '', "queue_bind");
eval { $mq->tx_select(1); };
is($@, '', "tx_select");
eval { $mq->publish(1, $routekey, "Magic Transient Payload", { exchange => $exchange }); };
eval { $mq->tx_rollback(1); };
is($@, '', "tx_rollback");
eval { $mq->publish(1, $routekey, "Magic Transient Payload (Commit)", { exchange => $exchange }); };
eval { $mq->tx_commit(1); };
is($@, '', "tx_commit");
eval { $mq->consume(1, $queuename, {consumer_tag=>'ctag', no_local=>0,no_ack=>1,exclusive=>0} ); };
is($@, '', "consume");

my $rv = {};
eval { $rv = $mq->recv(); };
is($@, '', "recv");

is_deeply($rv,
          {
          'body' => 'Magic Transient Payload (Commit)',
          'routing_key' => $routekey,
          'delivery_tag' => $dtag,
          'redelivered' => 0,
          'exchange' => $exchange,
          'consumer_tag' => 'ctag',
          'props' => {},
          }, "payload");

# Clean up
eval { $mq->cancel(1, 'ctag'); };
is($@, '', 'cancel');

eval { $mq->exchange_delete(1, $exchange); };
is($@, '', "exchange_delete");

1;
