 #####################################################################
#####################################################################
##
## 
## Here starts the actual thing.
#
package PDL::PP;
use PDL::Types;
use FileHandle;
require Exporter;
@ISA = qw(Exporter);

@EXPORT = qw/pp_addhdr pp_addpm pp_def pp_done pp_add_boot pp_add_exported pp_addxs/;

use Carp;

# use strict qw/vars refs/;

sub import {
	my ($mod,$modname, $packname, $prefix) = @_;
	$::PDLMOD=$modname; $::PDLPACK=$packname; $::PDLPREF=$prefix;
	$::PDLXS="";
	$::PDLPMROUT="";
	$::PDLPM="";
	@_=("PDL::PP");
	goto &Exporter::import;
}

sub pp_addhdr {
	my ($hdr) = @_;
	$::PDLXSC .= $hdr;
}

sub pp_addpm {
	my ($pm) = @_;
	$::PDLPM .= $pm;
}

sub pp_add_exported {
	my ($this,$exp) = @_;
	$::PDLPMROUT .= $exp." ";
}

sub pp_add_boot {
	my ($boot) = @_;
	$::PDLXSBOOT .= $boot." ";
}

sub printxs {
	shift;
	$::PDLXS .= join'',@_;
}

sub pp_addxs {
	PDL::PP->printxs(@_);
}

sub printxsc {
	shift;
	$::PDLXSC .= join '',@_;
}

sub pp_done {
	print "DONE!\n";
	(my $fh = new FileHandle(">$::PDLPREF.xs")) or die "Couldn't open xs file\n";

$fh->print(qq%
/*
 * THIS FILE WAS GENERATED BY PDL::PP! Do not modify!
 */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "pdl.h"
#include "pdlcore.h"
static Core* PDL; /* Structure hold core C functions */
static int __pdl_debugging = 0;
SV* CoreSV;       /* Get's pointer to perl var holding core structure */

$::PDLXSC

MODULE = $::PDLMOD PACKAGE = $::PDLMOD

int
set_debugging(i)
	int i;
	CODE:
	RETVAL = __pdl_debugging;
	__pdl_debugging = i;
	OUTPUT:
	RETVAL
 
$::PDLXS

BOOT:
   /* Get pointer to structure of core shared C routines */
   CoreSV = perl_get_sv("PDL::SHARE",FALSE);  /* SV* value */
   if (CoreSV==NULL)
     croak("This module requires use of PDL::Core first");
   PDL = (Core*) (void*) SvIV( CoreSV );  /* Core* value */
   $::PDLXSBOOT
%);                                                                

	($fh = new FileHandle(">$::PDLPREF.pm")) or die "Couldn't open pm file\n";

$fh->print(qq%
# 
# GENERATED WITH PDL::PP! Don't modify!
#
package $::PDLPACK;

\@EXPORT = qw( $::PDLPMROUT);

use PDL::Core;
use DynaLoader;
\@ISA    = qw( PDL::Exporter DynaLoader ); 

bootstrap $::PDLMOD;

$::PDLPM;

;# Exit with OK status

1;

%);

}

sub pp_def {
	my($name,%hash) = @_;
	$hash{Name} = $name;
	translate(\%hash,$PDL::PP::deftbl);
	my $obj = \%hash;
	if($hash{Dump}) {
		print Dumper(\%hash);
	}
	if(!$obj->{FreeFunc}) {
		croak("Cannot free this obj!\n");
	}
	PDL::PP->printxsc(join "\n\n",@$obj{StructDecl,RedoDimsFunc,
		CopyFunc,
		ReadDataFunc,WriteBackDataFunc,
		FreeFunc,
		VTableDef,NewXSInPrelude,
		}
		);
	PDL::PP->printxs($$obj{NewXSCode});
	pp_add_boot($$obj{XSBootCode} . $$obj{BootSetNewXS});
	PDL::PP->pp_add_exported($name);
	if($$obj{PMFunc}) {
		pp_addpm($$obj{PMFunc});
	}
}


# Worst memleaks: not freeing things at redodims or
# final free time (thread, dimmed things).

use Carp;
$SIG{__DIE__} = sub {print Carp::longmess(@_); die;};

# Rule table syntax: 
# make  $_->[0] from $_->[1]. 
# use "=" to assign to 1. unless "_" appended to parname, then use ".="

use PDL::PP::CType;
use PDL::PP::XS;
use PDL::PP::SymTab;
use PDL::PP::PDLCode;

$|=1;

$PDL::PP::deftbl =
[
 [[CopyName],	[],	sub {"__copy"}],
 [[DefaultFlow], [],	sub {0}],
 [[DefaultFlowCodeNS] ,[DefaultFlow], 
 	sub {$_[0]?'$PRIV(flags) |= PDL_ITRANS_DO_DATAFLOW_F | PDL_ITRANS_DO_DATAFLOW_B;':''}],

 	
# Default: no otherpars
 [[OtherPars],	[],	sub {""}],
# [[Comp],	[],	sub {""}],
# Naming of the struct and the virtual table.
 [[StructName],		[Name],			"defstructname"],
 [[FHdrInfo],		[Name,StructName],		"mkfhdrinfo"],
 [[VTableName],		[Name],			"defvtablename"],

# Treat exchanges as affines. Affines assumed to be parent->child.
# Exchanges may, if the want, handle threadids as well.
# Same number of dimensions is assumed, though.
 [[AffinePriv],		[XCHGOnly],		"direct"],
 [[Priv],	[AffinePriv],		"affinepriv"],
 [[IsAffineFlag],	[AffinePriv],	sub {"PDL_ITRANS_ISAFFINE"}],

 [[RedoDims],		[EquivPDimExpr,FHdrInfo],	"pdimexpr2priv"],
 [[RedoDims],		[Identity,FHdrInfo],	"identity2priv"],

 [[EquivCPOffsCode],	[Identity],	sub {'
 	int i;
	for(i=0; i<$CHILD_P(nvals); i++)  {
		$EQUIVCPOFFS(i,i);
	}
 	'}],

 [[Code],	[EquivCPOffsCode],	sub {my($ret) = @_;	
		  $ret =~ s/\$EQUIVCPOFFS\(([^()]+),([^()]+)\)/\$PP(CHILD)[$1] = \$PP(PARENT)[$2]/g;
		  $ret;
		  }],
 [[BackCode],	[EquivCPOffsCode],	sub {my($ret) = @_;	
		  $ret =~ s/\$EQUIVCPOFFS\(([^()]+),([^()]+)\)/\$PP(PARENT)[$2] = \$PP(CHILD)[$1]/g;
		  $ret;
		  }],
 [[Affine_Ok],	[EquivCPOffsCode],	sub {0}],
 [[Affine_Ok],	[],			sub {1}],

 [[ReadDataFuncName],	[AffinePriv],	sub {NULL}],
 [[WriteBackDataFuncName],	[AffinePriv],	sub {NULL}],

 [[BootStruct],	[AffinePriv,VTableName], sub {"$_[1].readdata = PDL->readdata_affine;
 					$_[1].writebackdata = PDL->writebackdata_affine;"}],

 [[ReadDataFuncName],	[Name],	sub {"pdl_$_[0]_readdata"}],
 [[CopyFuncName],	[Name],	sub {"pdl_$_[0]_copy"}],
 [[FreeFuncName],	[Name],	sub {"pdl_$_[0]_free"}],
# [[WriteBackDataFuncName],	[Name],	sub {"pdl_$_[0]_writebackdata"}],
 [[RedoDimsFuncName],	[Name],	sub {"pdl_$_[0]_redodims"}],

 [[XSBootCode],	[BootStruct],	sub {join '',@_}],


# Parameters in the form 'parent and child(this)'.
# The names are PARENT and CHILD.
#
# P2Child implicitly means "no data type changes".
 [[USParNames,USParObjs,FOOFOONoConversion,HaveThreading,NewXSName,PMFunc],   [P2Child,Name],
 		"ParentChildPars"],
 [[NewXSName],	[Name],	"direct"],

 [[EquivPThreadIdExpr],[P2Child],sub {'$CTID-$PARENT(ndims)+$CHILD(ndims)'}],

 [[HaveThreading],	[],	sub {1}],

# Parameters in the 'a(x,y); [o]b(y)' format, with
# fixed nos of real, unthreaded-over dims.
 [[USParNames,USParObjs,DimmedPars], 	[Pars], 		"Pars_nft"],
 [[DimObjs],		[USParNames,USParObjs],	"ParObjs_DimObjs"],

# "Other pars", the parameters which are usually not pdls.
 [[OtherParNames,
   OtherParTypes],	[OtherPars],		"OtherPars_nft"],

 [[ParNames,ParObjs],	[USParNames,USParObjs],	"sort_pnobjs"],

 [[NewXSArgs],		[USParNames,USParObjs,OtherParNames,OtherParTypes],
 						"NXArgs"],
 [[NewXSHdr],		[NewXSName,NewXSArgs],	"XSHdr"],
 [[NewXSCHdrs],		[NewXSName,NewXSArgs,GlobalNew],	"XSCHdrs"],
 [[DefSyms],		[StructName],			"MkDefSyms"],
 [[NewXSSymTab],	[DefSyms,NewXSArgs],	"AddArgsyms"],
 [[NewXSLocals],	[NewXSSymTab],		"Sym2Loc"],
 [[IsAffineFlag],	[],	sub {return "0"}],
 [[NewXSStructInit0],	[NewXSSymTab,
 			 VTableName,
			 IsAffineFlag,
			 ],		"MkPrivStructInit"],
 [[NewXSMakeNow],	[ParNames,NewXSSymTab],	"MakeNows"],
 [[IgnoreTypesOf],	[FTypes],	sub {return {map {($_,1)} keys %{$_[0]}}}],
 [[IgnoreTypesOf],	[],	sub {{}}],

 [[NewXSCoerceMustNS],	[FTypes],	"make_newcoerce"],
 [[NewXSCoerceMust],	[NewXSCoerceMustNS,NewXSSymTab,Name], "dousualsubsts"],

 [[DefaultFlowCode],	[DefaultFlowCodeNS,NewXSSymTab,Name], "dousualsubsts"],

 [[GenericTypes],	[],	sub {[B,S,U,L,F,D]}], 
#  [[GenericTypes],	[],	sub {[F,D]}],

 [[NewXSFindDatatypeNS],	[ParNames,ParObjs,IgnoreTypesOf,NewXSSymTab,
				GenericTypes],	
 						"find_datatype"],

 [[NewXSFindDatatype],	[NewXSFindDatatypeNS,NewXSSymTab,Name],	
 						"dousualsubsts"],
 [[NewXSTypeCoerce],	[NoConversion],		sub {""}],

 [[NewXSTypeCoerceNS],	[ParNames,ParObjs,IgnoreTypesOf,NewXSSymTab],
 						"coerce_types"],

 [[NewXSTypeCoerce],	[NewXSTypeCoerceNS,NewXSSymTab,Name], "dousualsubsts"],

 [[NewXSStructInit1],	[ParNames,NewXSSymTab],	"CopyPDLPars"],
 [[NewXSSetTrans],	[ParNames,ParObjs,NewXSSymTab],	"makesettrans"],

 [[ExtraGenericLoops],	[FTypes],	sub {return $_[0]}],
 [[ExtraGenericLoops],	[],	sub {return {}}],

 [["ParsedCode"],	[Code,ParNames,ParObjs,DimObjs,GenericTypes,
 			 ExtraGenericLoops,HaveThreading],	
 				sub {new PDL::PP::Code(@_)}],
 [["ParsedBackCode"],	[BackCode,ParNames,ParObjs,DimObjs,GenericTypes,
 			 ExtraGenericLoops,HaveThreading],	
 				sub {new PDL::PP::Code(@_)}],

# Compiled representations i.e. what the xsub function leaves
# in the trans structure. By default, copies of the parameters
# but in many cases (e.g. slice) a benefit can be obtained
# by parsing the string in that function.

# If the user wishes to specify his own code and compiled representation,
# The next two definitions allow this.
# Because of substitutions that will be there, 
# makecompiledrepr et al are array refs, 0th element = string,
# 1th element = hashref of translated names
# This makes the objects: type + ...
 [[CompNames,CompObjs],	[Comp],			"OtherPars_nft"],
 [[CompiledRepr],	[CompNames,CompObjs],	"NT2Decls_p"],
 [[MakeCompiledRepr],	[MakeComp,CompNames,CompObjs],		
 						sub {subst_makecomp(COMP,@_)}],

 [[CompCopyCode],	[CompNames,CompObjs,CopyName], "NT2Copies_p"],
 [[CompFreeCode],	[CompNames,CompObjs], 	"NT2Free_p"],

# This is the default
 [[MakeCompiledRepr],	[OtherParNames,OtherParTypes,
  			 NewXSSymTab],
 						"CopyOtherPars"],
 [[CompiledRepr],	[OtherParNames,OtherParTypes],
 						"NT2Decls"],
 [[CompCopyCode],	[OtherParNames,OtherParTypes,CopyName], "NT2Copies_p"],
 [[CompFreeCode],	[OtherParNames,OtherParTypes], "NT2Free_p"],



# Threads
 [[Priv,PrivIsInc],	[ParNames,ParObjs,DimObjs],	"make_incsizes"],
 [[PrivCopyCode],	[ParNames,ParObjs,DimObjs,CopyName,PrivIsInc],	
 	"make_incsize_copy"],
 [[PrivFreeCode],	[ParNames,ParObjs,DimObjs,PrivIsInc],	
 	"make_incsize_free"], # Frees thread.
 [[RedoDims],	[ParNames,ParObjs,DimObjs,DimmedPars],	"make_redodims_thread"],

 [[Priv],	[],			"nothing"],

 [[PrivNames,PrivObjs],	[Priv],			"OtherPars_nft"],
 [[PrivateRepr],	[PrivNames,PrivObjs],	"NT2Decls_p"],
 [[PrivCopyCode],	[PrivNames,PrivObjs,CopyName], "NT2Copies_p"],
 [[PrivFreeCode],	[PrivNames,PrivObjs], "NT2Free_p"],

 [[IsReversibleCodeNS],	[Reversible],	"ToIsReversible"],
 [[IsReversibleCode],	[IsReversibleCodeNS,NewXSSymTab,Name], "dousualsubsts"],

 [[NewXSStructInit2],	[MakeCompiledRepr, NewXSSymTab,Name],	sub {"{".dosubst(@_)."}"}],
 
 [[CopyCodeNS],	[PrivCopyCode,CompCopyCode,StructName],	sub {"$_[2] *__copy
 			= malloc(sizeof($_[2])); 
			PDL_TR_CLRMAGIC(__copy);
			__copy->flags = \$PRIV(flags);
			__copy->vtable = \$PRIV(vtable);
			__copy->__datatype = \$PRIV(__datatype);
			__copy->freeproc = NULL;
			__copy->__ddone = \$PRIV(__ddone);
			{int i;
			 for(i=0; i<__copy->vtable->npdls; i++) 
				__copy->pdls[i] = \$PRIV(pdls[i]);
			}
			$_[1]
			if(__copy->__ddone) {
				$_[0]
			}
			return (pdl_trans*)__copy;"}],
 
 [[FreeCodeNS],	[PrivFreeCode,CompFreeCode],	sub {"
			PDL_TR_CLRMAGIC(__privtrans);
			$_[1]
			if(__privtrans->__ddone) {
				$_[0]
			}
			"}],

 [[CopyCode],	[CopyCodeNS,NewXSSymTab,Name], "dousualsubsts"],
 [[FreeCode],	[FreeCodeNS,NewXSSymTab,Name], "dousualsubsts"],

 [[NewXSCoerceMust],	[],	sub {""}],
 [[NewXSCoerceMustSub1], [NewXSCoerceMust],	sub{subst_makecomp(FOO,@_)}],
 [[NewXSCoerceMustSubs], [NewXSCoerceMustSub1,NewXSSymTab,Name],	"dosubst"],

 [[NewXSCode,BootSetNewXS,NewXSInPrelude
  ],		[_GlobalNew,_NewXSCHdrs,NewXSHdr,NewXSLocals,NewXSStructInit0,
 			 NewXSMakeNow, NewXSFindDatatype,NewXSTypeCoerce,
			 NewXSStructInit1,
			 NewXSStructInit2, 
			 NewXSCoerceMustSubs,_IsReversibleCode,DefaultFlowCode,
			 NewXSSetTrans,
			 ],	"mkxscat"],
 [[StructDecl],		[ParNames,ParObjs, CompiledRepr,
                         PrivateRepr,StructName],		
			 			"mkstruct"],
 [[RedoDimsSub],	[RedoDims,PrivNames,PrivObjs],
					sub {subst_makecomp(PRIV,"$_[0] \$PRIV(__ddone) = 1;",@_[1,2])}],
 [[RedoDimsSubd],	[RedoDimsSub,NewXSSymTab,Name],	"dosubst"],
 [[RedoDimsFunc], 	[RedoDimsSubd,FHdrInfo,RedoDimsFuncName],	
 				sub {wrap_vfn(@_,"redodims")}],

#  [[ReGenedCode],	[ParsedCode,ParObjs,DimObjs],	sub {$_[0]->gen($_[1,2])}],
 [[ReadDataSub],	[ParsedCode],	sub {subst_makecomp(FOO,@_)}],
 [[ReadDataSubd],	[ReadDataSub,NewXSSymTab,Name],	"dosubst"],
 [[ReadDataFunc], 	[ReadDataSubd,FHdrInfo,ReadDataFuncName],	sub {wrap_vfn(@_,"readdata")}],

 [[WriteBackDataSub],	[ParsedBackCode],	sub {subst_makecomp(FOO,@_)}],
 [[WriteBackDataSubd],	[WriteBackDataSub,NewXSSymTab,Name],	"dosubst"],

 [[WriteBackDataFuncName],	[BackCode,Name],	sub {"pdl_$_[1]_writebackdata"}],
 [[WriteBackDataFuncName],	[Code],	sub {"NULL"}],

 [[WriteBackDataFunc], 	[WriteBackDataSubd,FHdrInfo,WriteBackDataFuncName],	
 	sub {wrap_vfn(@_,"writebackdata")}],
 
 [[CopyFunc],	[CopyCode,FHdrInfo,CopyFuncName],sub {wrap_vfn(@_,"copy")}],
 [[FreeFunc],	[FreeCode,FHdrInfo,FreeFuncName],sub {wrap_vfn(@_,"free")}],

 [[VTableDef],	[VTableName, StructName, RedoDimsFuncName,ReadDataFuncName,
 		 WriteBackDataFuncName,CopyFuncName,FreeFuncName,
		 ParNames,ParObjs,Affine_Ok],	"def_vtable"],
];

sub printtrans {
	my($bar) = @_;
	for (qw/StructDecl RedoDimsFunc ReadDataFunc WriteBackFunc
		VTableDef NewXSCode/) {
		print "\n\n================================================
	$_
=========================================\n",$bar->{$_},"\n";
	}
}

# use Data::Dumper;

use Carp;
# use Data::Dumper;

sub translate {
	my($pars,$tbl) = @_;
	my $rule;
	RULE: for $rule(@$tbl) {
# Are all prerequisites there;
		my @args;
#		print "Trying rule ",Dumper($rule) if $::PP_VERBOSE;
		for(@{$rule->[0]}) {
			if(exists $pars->{$_}) {
				print "Not applying rule $rule->[2], resexist\n"
				 if $::PP_VERBOSE;
				next RULE
			}
		}
		for(@{$rule->[1]}) {
			my $foo = $_;
			if(/^_/) {
				$foo =~ s/^_//;
			} elsif(!exists $pars->{$_}) {
				print "Component $_ not found for $rule->[2], next rule\n" if $::PP_VERBOSE;
				next RULE
			}
			push @args, $pars->{$foo};
		}
#		print "Applying rule $rule->[2]\n",Dumper($rule);
		print "Applying rule $rule->[2]\n" if $::PP_VERBOSE;
		@res = &{$rule->[2]}(@args);
		print "Setting " if $::PP_VERBOSE;
		for(@{$rule->[0]}) {
			if(exists $pars->{$_}) {
				confess "Cannot have several meanings yet\n";
			}
			print "$_ " if $::PP_VERBOSE;
			$pars->{$_} = shift @res;
		}
		print "\n" if $::PP_VERBOSE;
	}
#	print Dumper($pars);
	print "GOING OUT!\n";
	return $pars;
}

use Carp;

# ==== FCN ====

sub ToIsReversible {
	my($rev) = @_;
	if($rev eq "1") {
		'$SETREVERSIBLE(1)'
	} else {
		$rev
	}
}

sub make_newcoerce {
	my($ftypes) = @_;
	join '',map {
		"$_->datatype = $ftypes->{$_}; "
	} (keys %$ftypes);
}

sub coerce_types {
	my($parnames,$parobjs,$ignore,$newstab) = @_;
	(join '',map {
		my $dtype = ($parobjs->{$_}->{FlagInt}) ?
			" PDL_L " : "\$PRIV(__datatype)";
		($ignore->{$_} ? () :
		 $parobjs->{$_}->{FlagCreateAlways} ? 
		  "$_->datatype = $dtype; " :
		   "if((($_->state & PDL_NOMYDIMS) && 
		         $_->trans == NULL) &&
		       0$parobjs->{$_}->{FlagCreat}) {
			  $_->datatype = $dtype;  
		    } else if($dtype != $_->datatype) {
			$_ = PDL->get_convertedpdl($_,$dtype);
		    }")} (@$parnames))
}

# First, finds the greatest datatype, then, if not supported, takes
# the largest type supported by the function.
# Not yet optimal.
sub find_datatype {
	my($parnames,$parobjs,$ignore,$newstab,$gentypes) = @_;
	"\$PRIV(__datatype) = 0;".
	(join '', map {
		($parobjs->{$_}->{FlagInt}) ? () :
#		print "FD: $_, $ignore->{$_}, $parobjs->{$_}->{FlagCreateAlways}\n";
		($ignore->{$_} ||
		 $parobjs->{$_}->{FlagCreateAlways} ? () :
		 "if(".
		   ($parobjs->{$_}->{FlagCreat}?
		      "!(($_->state & PDL_NOMYDIMS) &&
		       $_->trans == NULL) && " : "")
		       ."
		 	\$PRIV(__datatype) < $_->datatype) {
		 	\$PRIV(__datatype) = $_->datatype;
		  }
		  ")
	}(@$parnames)).
	(join '', map {
		"if(\$PRIV(__datatype) == PDL_$_) {
		 } else "
	}(@$gentypes))."\$PRIV(__datatype) = PDL_$gentypes->[-1];";
}

sub make_incsizes {
	my($parnames,$parobjs,$dimobjs) = @_;
	"pdl_thread __thread; ".
	 (join '',map {$parobjs->{$_}->get_incdecls} @$parnames).
	 (join '',map {$_->get_decldim} values %$dimobjs);
}

sub make_incsize_copy {
	my($parnames,$parobjs,$dimobjs,$copyname) = @_;
	"PDL->thread_copy(&(\$PRIV(__thread)),&($copyname->__thread));".
	 (join '',map {$parobjs->{$_}->get_incdecl_copy(sub{"\$PRIV($_[0])"},
	 						sub{"$copyname->$_[0]"})} @$parnames).
	 (join '',map {$_->get_copydim(sub{"\$PRIV($_[0])"},
						sub{"$copyname->$_[0]"})} values %$dimobjs);
	 
}

sub make_incsize_free {
	my($parnames,$parobjs,$dimobjs) = @_;
	'PDL->freethreadloop(&($PRIV(__thread)));'
}

sub make_parnames {
	my($pnames,$pobjs,$dobjs) = @_;
	my @pdls = map {$pobjs->{$_}} @$pnames;
	my $npdls = $#pdls+1;
	return("static char *__parnames[] = {".
			(join ",",map {qq|"$_"|} @$pnames)."};
		static int __realdims[] = {".
			(join ",",map {$#{$_->{IndObjs}}+1} @pdls). "};
		static char __funcname[] = \"\$MODULE(): \$NAME()\";
		static pdl_errorinfo __einfo = {
			__funcname, __parnames, $npdls
		};
		");
}

sub make_redodims_thread {
	my($pnames,$pobjs,$dobjs) = @_;
	my $str; my $npdls = @$pnames;
	$str .= "int __creating[$npdls];";
	$str .= join '',map {$_->get_initdim."\n"} values %$dobjs;
	$str .= join '',map {"__creating[$_] = 
			(PDL_CR_SETDIMSCOND(__privtrans,\$PRIV(pdls[$_])))
				&& ".($pobjs->{$pnames->[$_]}{FlagCreat}?1:0)." ;\n"} (0..$#$pnames);
	$str .= join '',map {"if((!__creating[$_]) && \$PRIV(pdls[$_])->
				  ndims == 1 && \$PRIV(pdls[$_])->dims[0] == 0)
				   \$CROAK(\"CANNOT CREATE PARAMETER $pobjs->{$pnames->[$_]}{Name}\");
					"} (0..$#$pnames);
	$str .= " {\n " . make_parnames($pnames,$pobjs,$dobjs) . "
		 PDL->initthreadstruct(2,\$PRIV(pdls),
			__realdims,__creating,$npdls,
			&__einfo,&(\$PRIV(__thread)));
		}\n";
	$str .= join '',map {$pobjs->{$_}->get_xsnormdimchecks()} @$pnames;
	$str .= join '',map {$pobjs->{$pnames->[$_]}->
				get_incsets("\$PRIV(pdls[$_])")} 0..$#$pnames;
	$str;
}

sub def_vtable {
	my($vname,$sname,$rdname,$rfname,$wfname,$cpfname,$ffname,
		$pnames,$pobjs,$affine_ok) = @_;
	my $nparents = 0 + grep {! $pobjs->{$_}->{FlagW}} @$pnames;
	my $aff = ($affine_ok ? "PDL_TPDL_VAFFINE_OK" : 0);
	my $npdls = scalar @$pnames;
	"static char ${vname}_flags[] = 
	 	{ ".
	 	(join",",map {$aff} 1..$npdls).
			"};
	 pdl_transvtable $vname = {
		0,0, $nparents, $npdls, ${vname}_flags, 
		$rdname, $rfname, $wfname,
		$ffname,NULL,NULL,$cpfname,NULL,
		sizeof($sname),\"$vname\"
	 };"
}

sub sort_pnobjs {
	my($pnames,$pobjs) = @_;
	my (@nn);
	for(@$pnames) {
		if(!($pobjs->{$_}{FlagW})) { push @nn,$_; }
	}
	for(@$pnames) {
		if(($pobjs->{$_}{FlagW})) { push @nn,$_; }
	}
	my $no = 0;
	for(@nn) {
		$pobjs->{$_}{Number} = $no++;
	}
	return (\@nn,$pobjs);
}

sub mkfhdrinfo {
	my($name,$sname) = @_;
	return {
		Name => $name,
		StructName => $sname,
	};
}

# XXX __privtrans explicit :(
sub wrap_vfn {
	my($code,$hdrinfo,$rout,$name) = @_;
        my $type = ($name eq "copy" ? "pdl_trans *" : "void");
	my $sname = $hdrinfo->{StructName};
        qq|$type $rout(pdl_trans *__tr) {
                int __dim;
                $sname *__privtrans = ($sname *) __tr;
                pdl *__it = __tr->pdls[1];
                pdl *__parent = __tr->pdls[0];
                {
			$code
		}
	}
        |;
}

sub makesettrans {
	my($pnames,$pobjs,$symtab) = @_;
	my $trans = $symtab->get_symname(_PDL_ThisTrans);
	my $no=0;
	(join '',map {
		"$trans->pdls[".($no++)."] = $_;\n"
	} @$pnames).
	"PDL->make_trans_mutual((pdl_trans *)$trans);\n"
}

sub identity2priv {
	'
		int i;
		$SETNDIMS($PARENT(ndims));
		for(i=0; i<$CHILD(ndims); i++) {
			$CHILD(dims[i]) = $PARENT(dims[i]);
		}
		$SETDIMS();
		$SETDELTATHREADIDS(0);
	'
}

sub pdimexpr2priv {
	my($pdimexpr) = @_;
	$pdimexpr =~ s/\$CDIM\b/i/g;
	'
		int i,cor;
		$SETNDIMS($PARENT(ndims));
		$DOPRIVDIMS();
		$PRIV(offs) = 0;
		for(i=0; i<$CHILD(ndims); i++) {
			cor = '.$pdimexpr.';
			$CHILD(dims[i]) = $PARENT(dims[cor]);
			$PRIV(incs[i]) = $PARENT(dimincs[cor]);
				
		}
		$SETDIMS();
		$SETDELTATHREADIDS(0);
	'
}

sub affinepriv {
	'PDL_Long incs[$CHILD(ndims)];PDL_Long offs; '
}

sub dousualsubsts {
	my($src,$symtab,$name) = @_;
	return dosubst([$src,
		{@::std_childparent}
	     ],$symtab,$name);
}

sub dosubst {
	my($src,$symtab,$name) = @_;
#	print "DOSUBST on ",Dumper($src),"\n";
	$ret = (ref $src ? $src->[0] : $src);
	my %syms = (
		((ref $src) ? %{$src->[1]} : ()),
		PRIV => sub {return "".$symtab->get_symname(_PDL_ThisTrans).
					"->$_[0]"},
		CROAK => sub {return "croak(\"Error in $name:\" $_[0])"},
		NAME => sub {return $name},
		MODULE => sub {return $::PDLMOD},
	SETREVERSIBLE => sub {"if($_[0]) \$PRIV(flags) |= PDL_ITRANS_REVERSIBLE;
				else \$PRIV(flags) &= ~PDL_ITRANS_REVERSIBLE;"},
	);
	while(
		$ret =~ s/\$(\w+)\(([^()]*)\)/
			(defined $syms{$1} or
				confess("$1 not defined in '$ret'!")) and
			(&{$syms{$1}}($2))/ge
	) {};
	$ret;
}

BEGIN {
@::std_childparent = (
	CHILD => sub {return '$PRIV(pdls[1]->'.(join ',',@_).")"},
	PARENT => sub {return '$PRIV(pdls[0]->'.(join ',',@_).")"},
	CHILD_P => sub {return '$PRIV(pdls[1]->'.(join ',',@_).")"},
	PARENT_P => sub {return '$PRIV(pdls[0]->'.(join ',',@_).")"},
	CHILD_PTR => sub {return '$PRIV(pdls[1])'},
	PARENT_PTR => sub {return '$PRIV(pdls[0])'},
	COMP => sub {return '$PRIV('.(join ',',@_).")"},
);
@::std_redodims = (
	SETNDIMS => sub {return "PDL->reallocdims(__it,$_[0])"},
	SETDIMS => sub {return "PDL->setdims_careful(__it)"},
	SETDELTATHREADIDS => sub {return '
		{int __ind; PDL->reallocthreadids($CHILD_PTR(),
			$PARENT(nthreadids));
		for(__ind=0; __ind<$PARENT(nthreadids)+1; __ind++) {
			$CHILD(threadids[__ind]) =
				$PARENT(threadids[__ind]) + ('.$_[0].');
		}
		}
		'}
				
);
}


sub subst_makecomp {
	my($which,$mc,$cn,$co) = @_;
	return [$mc,{
		@::std_childparent,
		($cn ? 
			((DO.$which.DIMS) => sub {return join '',
				map{$$co{$_}->need_malloc ?
				    $$co{$_}->get_malloc('$PRIV('.$_.')') :
				    ()} @$cn}) :
			()
		),
		($which eq "PRIV" ?
			@::std_redodims : ()),
		},
	];
}

sub ParentChildPars {
	my($p2child,$name) = @_;
	return (Pars_nft("PARENT(); [oca]CHILD();"),0,"${name}_XX",
	"
	sub $name {
		my \$foo=PDL->null;
		my \$this = shift;
		${name}_XX(\$this,\$foo,\@_);
		\$foo
	}
	");
}

sub mkstruct {
	my($pnames,$pobjs,$comp,$priv,$name) = @_;
	my $npdls = $#$pnames+1;
	my $decl = "typedef struct $name {
		PDL_TRANS_START($npdls);
		$priv
		$comp
		char __ddone; /* Dims done */
		} $name;";
	return $decl;
}

sub nothing {return "";}

sub NT2Decls_p {&NT2Decls__({ToPtrs=>1},@_);}

sub NT2Copies_p {&NT2Copies__({ToPtrs=>1},@_);}

sub NT2Free_p {&NT2Free__({ToPtrs=>1},@_);}

sub NT2Decls {&NT2Decls__({},@_);}

sub NT2Decls__ {
	my($opts,$onames,$otypes) = @_; my $decl;
	my $dopts = {};
	if($opts->{ToPtrs}) {
		$dopts->{VarArrays2Ptrs} = 1;
	}
	for(@$onames) {
		$decl .= $otypes->{$_}->get_decl($_,$dopts).";";
	}
	$decl
}

sub NT2Copies__ {
	my($opts,$onames,$otypes,$copyname) = @_; my $decl;
	my $dopts = {};
	if($opts->{ToPtrs}) {
		$dopts->{VarArrays2Ptrs} = 1;
	}
	for(@$onames) {
		$decl .= $otypes->{$_}->get_copy("\$PRIV($_)","$copyname->$_",
			$dopts).";";
	}
	$decl
}

sub NT2Free__ {
	my($opts,$onames,$otypes) = @_; my $decl;
	if($opts->{ToPtrs}) {
		$dopts->{VarArrays2Ptrs} = 1;
	}
	for(@$onames) {
		$decl .= $otypes->{$_}->get_free("\$PRIV($_)",
			$dopts).";";
	}
	$decl
}

sub CopyOtherPars {
	my($onames,$otypes,$symtab) = @_; my $repr; 
	my $sname = $symtab->get_symname(_PDL_ThisTrans);
	for(@$onames) {
		$repr .= $otypes->{$_}->get_copy("$_","$sname->$_");
	}
	return $repr;
}

sub mkxscat {
	my($glb,$chdrs,$hdr,@bits) = @_;
	my($xscode,$boot,$prel,$str);
	if($glb) {
		$prel = $chdrs->[0] . "@bits" . $chdrs->[1];
		$boot = $chdrs->[3];
		$str = "$hdr\n";
	} else {
		$xscode = join '',@bits;
		$str = "$hdr CODE:\n { $xscode XSRETURN(0);\n}\n\n";
	}
	$str =~ s/(\s*\n)+/\n/g;
	($str,$boot,$prel)
}

# Not necessary ?
sub CopyPDLPars {
if(0) {
	my($pnames,$symtab) = @_;
	my $tt = $symtab->get_symname(_PDL_ThisTrans);
	my $str; my $no=0;
	for(@$pnames) {
		$str .= "$tt->pdls[$no] = ".$_.";\n";
		$no++;
	}
	$str
}
	""
}

sub direct {return @_;}

sub MakeNows {
	my($pnames, $symtab) = @_;
	my $str;
	for(@$pnames) {
		$str .= "$_ = PDL->make_now($_);\n";
	}
	$str;
}

sub Sym2Loc {
	return $_[0]->decl_locals();
}

sub defstructname {return "pdl_$_[0]_struct"}
sub defvtablename {return "pdl_$_[0]_vtable"}

sub MkPrivStructInit {
	my($symtab,$vtable,$affflag) = @_;
	my $sname = $symtab->get_symname(_PDL_ThisTrans);
	return "$sname = malloc(sizeof(*$sname));
		PDL_TR_SETMAGIC($sname);
		$sname->flags = $affflag;
		$sname->__ddone = 0;
		$sname->vtable = &$vtable;
		$sname->freeproc = PDL->trans_mallocfreeproc;";
	return $init;
}

sub MkDefSyms {
	return new SymTab(
		_PDL_ThisTrans => ["__privtrans",new C::Type(undef,"$_[0] *foo")],
	);
}

sub AddArgsyms {
	my($symtab,$args) = @_;
	$symtab->add_params(
		map {($_->[0],$_->[0])} @$args
	);
	return $symtab;
}

# Eliminate whitespace entries
sub nospacesplit {map {/^\s*$/?():$_} split $_[0],$_[1]}

# Pars -> ParNames, Parobjs
sub Pars_nft {
	my($str) = @_;
	my @entries = nospacesplit ';',$str;
	my $number = 0;
	my %objs; my @names; my $obj;
	for (@entries) {
		$obj = new PDL::PP::PdlParObj($_,"PDL_UNDEF_NUMBER");
		push @names,$obj->name;
		$objs{$obj->name} = $obj;
	}
	return (\@names,\%objs,1);
}

# ParNames,Parobjs -> DimObjs
sub ParObjs_DimObjs {
	my($pnames,$pobjs) = @_;
	my ($dimobjs) = new PDL::PP::PdlDimsObj;
	for(@$pnames) {
		$pobjs->{$_}->add_inds($dimobjs);
	}
	return ($dimobjs);
}

sub OtherPars_nft {
	my($otherpars) = @_;
	my(@names,%types);
	for(nospacesplit ';',$otherpars) {
		my $type = new C::Type(undef,$_);
		my $name = $type->protoname;
		push @names,$name;
		$types{$name} = $type;
	}
	return (\@names,\%types);
}

sub NXArgs {
	my($parnames,$parobjs,$onames,$oobjs) = @_;
	my $pdltype = new C::Type(undef,"pdl *__foo__");
	my $nxargs = [
		( map {[$_,$pdltype]} @$parnames ),
		( map {[$_,$oobjs->{$_}]} @$onames )
	];
	return $nxargs;
}

sub XSHdr {
	my($xsname,$nxargs) = @_;
	return XS::mkproto($xsname,$nxargs);
}

sub XSCHdrs {
	my($name,$pars,$gname) = @_;
	my $shortpars = join ',',map {$_->[0]} @$pars;
	my $longpars = join ",",map {$_->[1]->get_decl($_->[0])} @$pars;
	return ["void $name($longpars) {","}","",
		"PDL->$gname = $name;"];
}

##############################################
package PDL::PP::PdlDimsObj; # Hold more dims
use Carp;

sub new {
	my($type) = @_;
	bless {},$type;
}

sub get_indobj_make {
	my($this,$expr) = @_;
	$expr =~ /^([a-zA-Z0-9]+)(?:=([0-9]+))?$/ or confess "Invalid index expr '$expr'\n";
	my $name = $1; my $val = $2;
	my $indobj;
	if(defined $this->{$name}) {
		$indobj = $this->{$name};
	} else {
		$indobj = PDL::PP::Ind->new($name);
		$this->{$name}=$indobj;
	}
	if(defined $val) { $indobj->add_value($val); }
	return $indobj;
}

##############################################
package PDL::PP::PdlParObj;
use Carp;

sub new {
	my($type,$string,$number) = @_;
	my $this = bless {Number => $number},$type;
# Parse the parameter string
	$string =~
		/^
		 \s*(int|)\s*	# $1: first option
		 (?:
			\[([^]]*)\]   	# $2: The initial [option] part
	         )?\s*
		 (\w+)          	# $3: The name
		 \(([^)]*)\)  		# $4: The indices
		/x or confess "Invalid pdl def $string\n";
	print "PDL: '$1', '$2', '$3', '$4'\n";
	my($opt1,$opt2,$name,$inds) = ($1,$2,$3,$4);
# Set my internal variables
	$this->{Name} = $name;
	$this->{Flags} = [(split ',',$opt2),($opt1?$opt1:())];
	for(@{$this->{Flags}}) {
		/^io$/ and $this->{FlagW}=1 or
		/^nc$/ and $this->{FlagNCreat}=1 or
		/^o$/ and $this->{FlagOut}=1 and $this->{FlagCreat}=1 and $this->{FlagW}=1 or
		/^oca$/ and $this->{FlagOut}=1 and $this->{FlagCreat}=1 and $this->{FlagW}=1 
			and $this->{FlagCreateAlways}=1 or
		/^t$/ and $this->{FlagTemp}=1 and $this->{FlagCreat}=1 and $this->{FlagW}=1 or
		/^int$/ and $this->{FlagInt} = 1 or
		/^phys$/ and $this->{FlagPhys} = 1 or
		confess("Invalid flag $_ given for $string\n");
	}
	if($this->{FlagNCreat}) {
		delete $this->{FlagCreat};
		delete $this->{FlagCreateAlways};
	}
	my @inds = map{
		s/\s//g; 		# Remove spaces
		$_;
	} split ',', $inds;
	$this->{RawInds} = [@inds];
	return $this;
}

sub get_nname{ my($this) = @_;
	"(\$PRIV(pdls[$this->{Number}]))";
}

sub add_inds {
	my($this,$dimsobj) = @_;
	$this->{IndObjs} = [map {$dimsobj->get_indobj_make($_)} 
		@{$this->{RawInds}}];
	my %indcount;
	$this->{IndCounts} = [
		map {
			0+($indcount{$_->name}++);
		} @{$this->{IndObjs}}
	];
	$this->{IndTotCounts} = [
		map {
			($indcount{$_->name});
		} @{$this->{IndObjs}}
	];
}

sub name {return (shift)->{Name}}

sub get_xsnormdimchecks { my($this) = @_;
	my $pdl = $this->get_nname;
	my $str = ""; my $ninds = 0+scalar(@{$this->{IndObjs}});
	$str .= "if(!__creating[$this->{Number}]) {";
	$str .= "
		if(($pdl)->ndims < $ninds) {
			\$CROAK(\"Too few dimensions for $this->{Name}\\n\");
		}
	";
# Now, the real check.
	my $no = 0;
	for(@{$this->{IndObjs}}) {
		my $siz = $_->get_size();
		my $dim = "($pdl)->dims[$no]";
		$str .= "
		  if($siz == -1 || $siz == 1) {
			$siz = $dim;
		  } else if($siz != $dim) {
		  	if($dim == 1) {
				/* Do nothing */ /* XXX Careful, increment? */
			} else {
				\$CROAK(\"Wrong dims\\n\");
			}
		  }
		";
		$no++;
	}
	$str .= "} else {";
# We are creating this pdl.
	if(!$this->{FlagCreat}) {
		$str .= qq'\$CROAK("Cannot create non-output argument $this->{Name}!\\n");';
	} else {
		$str .= "int dims[".($ninds+1)."]; /* Use ninds+1 to avoid smart (stupid) compilers */";
		$str .= join "",
		   (map {"dims[$_] = ".$this->{IndObjs}[$_]->get_size().";"} 
		      0..$#{$this->{IndObjs}});
		$str .="\n PDL->thread_create_parameter(&\$PRIV(__thread),$this->{Number},dims);\n"
	}
	$str .= "}";
	$str
}

sub get_incname {
	my($this,$ind) = @_;
	if($this->{IndTotCounts}[$ind] > 1) {
	    "__inc_".$this->{Name}."_".($this->{IndObjs}[$ind]->name).$this->{IndCounts}[$ind];
	} else {
	    "__inc_".$this->{Name}."_".($this->{IndObjs}[$ind]->name);
	}
}

sub get_incdecls {
	my($this) = @_;
	if(scalar(@{$this->{IndObjs}}) == 0) {return "";}
	(join '',map {
		"PDL_Long ".($this->get_incname($_)).";";
	} (0..$#{$this->{IndObjs}}) ) . ";"
}

sub get_incdecl_copy {
	my($this,$fromsub,$tosub) = @_;
	join '',map {
		my $iname = $this->get_incname($_);
		&$fromsub($iname)."=".&$tosub($iname).";";
	} (0..$#{$this->{IndObjs}}) 
}

sub get_incsets {
	my($this,$str) = @_;
	my $no=0; 
	(join '',map {
		"if($str->dims[$_] <= 1)
		  \$PRIV(".($this->get_incname($_)).") = 0; else
		 \$PRIV(".($this->get_incname($_)).
			") = PDL_REPRINC($str,$_);";
	} (0..$#{$this->{IndObjs}}) )
}
 
# Print an access part.
sub do_access {
	my($this,$inds,$context) = @_;
	my $pdl = $this->{Name};
# Parse substitutions into hash
	my %subst = map 
	 {/^\s*(\w+)\s*=>\s*(\w*)\s*$/ or confess "Invalid subst $_\n"; ($1,$2)} 
	 	split ',',$inds;
# Generate the text
	my $text = "(${pdl}_datap)"."[";
	$text .= join '+','0',map {
		$this->do_indterm($pdl,$_,\%subst,$context);
	} (0..$#{$this->{IndObjs}});
	$text .= "]";
# If not all substitutions made, the user probably made a spelling
# error. Barf.
	if(scalar(keys %subst) != 0) {
		confess("Substitutions left: ".(join ',',keys %subst)."\n");
	}
	return "$text /* ACCESS($access) */";
}

sub do_pointeraccess {
	my($this) = @_;
	return $this->{Name}."_datap";
}

sub do_physpointeraccess {
	my($this) = @_;
	return $this->{Name}."_physdatap";
}

sub do_indterm { my($this,$pdl,$ind,$subst,$context) = @_;
# Get informed
	my $indname = $this->{IndObjs}[$ind]->name;
	my $indno = $this->{IndCounts}[$ind];
	my $indtot = $this->{IndTotCounts}[$ind];
# See if substitutions
	my $substname = ($indtot>1 ? $indname.$indno : $indname);
	my $incname = $indname.($indtot>1 ? $indno : "");
	my $index;
	if(defined $subst->{$substname}) {$index = delete $subst->{$substname};}
	else {
# No => get the one from the nearest context.
		for(reverse @$context) {
			if($_->[0] eq $indname) {$index = $_->[1]; last;}
		}
	}
	if(!defined $index) {confess "Access Index not found: $pdl, $ind, $indname
		On stack:".(join ' ',map {"($_->[0],$_->[1])"} @$context)."\n" ;}
	return "\$PRIV(".($this->get_incname($ind))."*". $index .")";
}

sub get_xsdatapdecl { my($this,$genlooptype) = @_;
	my $type; my $pdl = $this->get_nname; my $name = $this->{Name};
	if(!grep {/^int$/} @{$this->{Flags}}) {
		$type = $genlooptype;
	} else {
		$type = "long";
	}
# ThreadLoop does this for us.
#	return "\t$type *${name}_datap = (($type *)((${_})->data)) + (${_})->offs;\n";
	return "\t$type *${name}_datap = (($type *)(PDL_REPRP($pdl)));
		$type *${name}_physdatap = (($type *)($pdl->data));
	\n";
}

#####################################################################
#
# Encapsulate one index.

package PDL::PP::Ind;
use Carp;

sub new {
	my($type,$name) = @_;
	my $this = bless {Name => $name},$type;
	return $this;
}

sub add_value {
	my($this,$val) = @_;
	if(defined $this->{Value}) {
		if($val != $this->{Value}) {
			confess("For index $this->{Name} conflicting values $this->{Value} and $val given\n");
		}
	} else {
		$this->{Value} = $val;
	}
}

# This index will take its size value from outside parameter ...
sub set_outsidepar { my($this,$outpar) = @_;
	$this->{OutsidePar} = $outpar;
}

sub name {return (shift)->{Name}}

sub get_decldim { my($this) = @_;
	return "PDL_Long __$this->{Name}_size;";
}

sub get_initdim { my($this) = @_;
	"\$PRIV(__$this->{Name}_size) = -1;"
}

sub get_copydim { my($this,$fromsub,$tosub) = @_;
	my($iname) = "__$this->{Name}_size";
	&$tosub($iname) ."=". &$fromsub($iname) .";" ;
}

sub get_size { my($this) = @_;
	"\$PRIV(__$this->{Name}_size)"
}

