/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.util.StringUtil;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class SeleniumHTMLRunnerResultsHandler
implements HttpHandler {
    HttpContext context;
    List listeners = new Vector();
    boolean started = false;

    public void addListener(HTMLResultsListener listener) {
        this.listeners.add(listener);
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse res) throws HttpException, IOException {
        if (!"/postResults".equals(pathInContext)) {
            return;
        }
        request.setHandled(true);
        String result = request.getParameter("result");
        if (result == null) {
            res.getOutputStream().write("No result was specified!".getBytes());
        }
        String totalTime = request.getParameter("totalTime");
        String numTestPasses = request.getParameter("numTestPasses");
        String numTestFailures = request.getParameter("numTestFailures");
        String numCommandPasses = request.getParameter("numCommandPasses");
        String numCommandFailures = request.getParameter("numCommandFailures");
        String numCommandErrors = request.getParameter("numCommandErrors");
        String suite = request.getParameter("suite");
        int numTotalTests = Integer.parseInt(numTestPasses) + Integer.parseInt(numTestFailures);
        List testTables = this.createTestTables(request, numTotalTests);
        HTMLTestResults results = new HTMLTestResults(result, totalTime, numTestPasses, numTestFailures, numCommandPasses, numCommandFailures, numCommandErrors, suite, testTables);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            HTMLResultsListener listener = (HTMLResultsListener)i.next();
            listener.processResults(results);
            i.remove();
        }
        this.processResults(results, res);
    }

    private void processResults(HTMLTestResults results, HttpResponse res) throws IOException {
        res.setContentType("text/html");
        OutputStream out = res.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out, StringUtil.__ISO_8859_1);
        results.write(writer);
        ((Writer)writer).flush();
    }

    private List createTestTables(HttpRequest request, int numTotalTests) {
        LinkedList<String> testTables = new LinkedList<String>();
        for (int i = 1; i <= numTotalTests; ++i) {
            String testTable = request.getParameter("testTable." + i);
            testTables.add(testTable);
        }
        return testTables;
    }

    public String getName() {
        return SeleniumHTMLRunnerResultsHandler.class.getName();
    }

    public HttpContext getHttpContext() {
        return this.context;
    }

    public void initialize(HttpContext c) {
        this.context = c;
    }

    public void start() throws Exception {
        this.started = true;
    }

    public void stop() throws InterruptedException {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }
}

