/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.IOException;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;

public class DestroyableRuntimeExecutingBrowserLauncher
implements BrowserLauncher {
    protected Process process;
    protected String commandPath;
    protected String sessionId;

    public DestroyableRuntimeExecutingBrowserLauncher(String commandPath, String sessionId) {
        this.commandPath = commandPath;
        this.sessionId = sessionId;
    }

    public void close() {
        this.process.destroy();
    }

    public void launch(String url) {
        this.exec(this.commandPath + " " + url);
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl));
    }

    public void launchRemoteSession(String browserURL) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId));
    }

    protected void exec(String command) {
        try {
            this.process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

