#!perl -T

BEGIN
{
  unless ( $ENV{ AUTHOR_TESTING } )
  {
    print qq{1..0 # SKIP these tests are for testing by the author\n};
    exit;
  }
}


# run it with 'prove -l -v xt'
# you can also set $ENV{'GOOGLE_TOKENSFILE'} and $ENV{'GMAIL_FOR_TESTING'}
# export GOOGLE_TOKENSFILE='cat.txt'

# https://developers.google.com/google-apps/calendar/v3/reference/

## TODO:
##  * add in scope checks
##  * use default email account
##  * investigate warning inline '3/10/2018 - TODO'

use 5.006;
use strict;
use warnings;
use feature 'say';
use Test::More;

# use lib 'lib'; # to test without dzil install
use WebService::Google::Client;
use Data::Dumper;
use Data::Printer;
$Data::Dumper::Maxdepth = 1;

=head2 USAGE

To run in the local directory assuming gapi.json present 
  C<prove -I../../../lib calendars.t -w -o -v>

=cut

# $SIG{'__WARN__'} = sub { warn $_[0] unless (caller eq "WebService::Google::Client"); };
# $SIG{'__WARN__'} = sub { warn $_[0] unless (caller eq "WebService::Google::Client::Client"); };

use Test::More;

# use Test::More tests => 3;

# $ENV{'GMAIL_FOR_TESTING'} = 'peter@shotgundriver.com';
my $default_file = $ENV{ 'GOOGLE_TOKENSFILE' } || '../../../gapi.json';
my $user         = $ENV{ 'GMAIL_FOR_TESTING' } || '';                     ## TODO - populate from gapi.json if needed

plan( skip_all => 'No user configuration - set $ENV{GOOGLE_TOKENSFILE}' ) unless -e $default_file;
plan( skip_all => 'Review required before enabling live' );

# warn $user;
my $gapi = WebService::Google::Client->new( debug => 0 );

if ( -e $default_file )
{
  $gapi->auth_storage->setup( { type => 'jsonfile', path => $default_file } ) || croak( $! );
  my $aref_token_emails = $gapi->auth_storage->storage->get_token_emails_from_storage;
  $user = $aref_token_emails->[0] unless $user;                           ## default to the first user if none defined yet
  $gapi->user( $user );
  note( "default_file = $default_file" );
  note( "user = $user" );


  ######################################## Calendars ###############
  # Insert new calendar
  # Test of clear (5), delete (6), get (2,7), insert (1), patch (4), update (3)
  # number in () -> sequence of subtest

  my $id;    # id of future created calendar
  my $sample_summary = 'New calendar';
  my $new_summary1   = 'New summary 1';
  my $new_summary2   = 'New summary 2';

  subtest 'Calendars->insert() subtest' => sub {
    my $t = $gapi->Calendar->Calendars->insert( { options => { summary => $sample_summary } } )->json;
    ok( ref( $t ) eq 'HASH', "Fine, insert() method returned a HASH, not ARRAY structure" );
    ok( $t->{ summary } eq $sample_summary );
    ok( $t->{ kind } eq 'calendar#calendar' );
    $id = $t->{ id };
    warn "ID of new calendar:" . $id;
  };

  subtest 'Calendars->get() subtest' => sub {
    my $t = $gapi->Calendar->Calendars->get( { calendarId => $id } )->json;
    ok( ref( $t ) eq 'HASH', "Fine, get() method returned a HASH, not ARRAY structure" );
    ok( $t->{ summary } eq $sample_summary );
    ok( $t->{ kind } eq 'calendar#calendar' );

#        warn $t->{timeZone};
    ok( $t->{ timeZone } eq 'Australia/Brisbane' )
      ;    # New calendar will be in UTC timezone by default .. or so he thought - mine came as my default for the G-Suite account Australia/Brisbane
  };
  ## 3/10/2018 - TODO - look at warning "calendars.t .. 4/? Attention! You are using POST, but no payload specified at /Library/Perl/5.18/WebService/Google/UserAgent.pm line 68."


  subtest 'Calendars->update() subtest' => sub {
    my $t = $gapi->Calendar->Calendars->update( { calendarId => $id, options => { summary => $new_summary1 } } )->json;
    ok( ref( $t ) eq 'HASH', "Fine, get() method returned a HASH, not ARRAY structure" );
    ok( $t->{ summary } eq $new_summary1 );
    ok( $t->{ kind } eq 'calendar#calendar' );
  };

  subtest 'Calendars->patch() subtest' => sub {
    my $t = $gapi->Calendar->Calendars->patch( { calendarId => $id, options => { summary => $new_summary2 } } )->json;
    ok( ref( $t ) eq 'HASH', "Fine, get() method returned a HASH, not ARRAY structure" );
    ok( $t->{ summary } eq $new_summary2 );
    ok( $t->{ kind } eq 'calendar#calendar' );
  };

# calendar that you inserted isn't a primary calendar, by default it's secondary
  subtest 'Calendars->clear() subtest' => sub {
    my $t = $gapi->Calendar->Calendars->clear( { calendarId => $id } )->json;
    ok( $t->{ error }{ message } eq 'Cannot clear primary calendar.' );
  };

  subtest 'Calendars->delete() subtest' => sub {
    ok( $gapi->Calendar->Calendars->delete( { calendarId => $id } )->is_empty );
  };

}
else
{
  #say 'Cant run test cause json file with tokens not exists!';
  plan( skip_all => 'No user configuration' );
}

done_testing();
