use v6.d;

# CompUnit::RepositoryRegistray is built-in,
# no need to "use" it.

sub EXPORT
{
    use FileSystem::Parent;

    my $resolve = ? @_.first( 'resolve' );
    my $verbose = ? @_.first( 'verbose' );

    my %fixed   =
    (
        append      => 'lib',
        filter      => 'dir',
        skip-root   => True
    );

    my @found   
    = scan-up( :$verbose, :$resolve, |%fixed );

    for @found.reverse -> $prefix
    {
        CompUnit::RepositoryRegistry.use-repository:
            CompUnit::Repository::FileSystem.new:
                :$prefix
    }

    # caller can look up what's there.

   %( '@FindBin-libs-dirs' => @found )
}

unit module FindBin::libs:ver<0.2.0>:auth<CPAN:lembark>;
=finish
