
use FindBin::libs;
use FindBin::libs   qw( base=t export=test_dir scalar );

use Test::More;
use File::Basename  qw( dirname );

my $print   = 'DEVEL_SHAREDLIBS_PRINT';

$ENV{ $print } = 1;

my $exec = $test_dir . '/bin/exec-stdout';

-e $exec or BAIL_OUT "Missing test exec: '$exec'";

chomp( my @output  = qx( $^X $exec ) );

ok ! $?, "$exec exits zero";

note "Output: $print = $ENV{ $print }\n", explain \@output;

ok @output, "True $print: has output.";

my @found   = grep /^[^#]/, @output;

ok -e $_, "Existing: '$_'"  for @found;

done_testing
__END__
