package GFX::Enhancer::SingleLineEnhancer;

### project a single line from e.g. a scanned in line

sub new {
	my ($class) = @_;

	my $self = { lines_points = (), }; ### lines_points are enhanced

	$class = ref($class) || $class;

	bless $self, $class;
}

sub process {
	my ($self, $imgrepr) = @_; 

	### points are PNGRGBAs

	for (my $i = 0; $i < length($imgrepr->{points}); $i++) {
		push($self->{lines_points}, $self->investigate_neighbourhood_of_points($i, $imgrepr, GFX::Enhancer::PointsInvestigator->new));
	}		
}

### private methods

sub investigate_neighbourhood_of_points {
	my ($self, $rgba_point_index, $imgrepr, $investigator) = @_;

	return ($investigator->calculate_neighbourhood($rgba_point_index, $imgrepr));
}

1;
