package AxKit::App::TABOO::Data::Plurals::Stories;
use strict;
use warnings;
use Carp;

use Data::Dumper;
use AxKit::App::TABOO::Data;
use AxKit::App::TABOO::Data::Story;
use AxKit::App::TABOO::Data::Plurals;


use vars qw/@ISA/;
@ISA = qw(AxKit::App::TABOO::Data::Plurals);

use DBI;
use Exception::Class::DBI;


our $VERSION = '0.07';

AxKit::App::TABOO::Data::Plurals::Stories->dbtable("stories");
AxKit::App::TABOO::Data::Plurals::Stories->dbfrom("stories");


=head1 NAME

AxKit::App::TABOO::Data::Plurals::Stories - Data objects to handle multiple Stories in TABOO

=head1 DESCRIPTION

Often, you want to retrieve many different stories from the data store, for example all belonging to a certain category or a certain section. This is a typical situation where this class shoule be used.

=head2 Methods

=over

=item C<new()>

The constructor. Nothing special.

=cut

sub new {
    my $that  = shift;
    my $class = ref($that) || $that;
    my $self = {
	ENTRIES => [], # Internally, some methods finds it useful that the entries are stored in a array of this name.
	XMLELEMENT => undef,
	XMLNS => undef,
    };
    bless($self, $class);
    return $self;
}


=item C<load(what => fields, limit => {key => value, [...]}, orderby => fields, entries = number)>

This load method can be used to retrieve a number of entries from a
data store.  It uses named parameters, the first C<what> is used to
determine which fields to retrieve. It is a string consisting of a
commaseparated list of fields, as specified in the data store. The
C<limit> argument is to be used to determine which records to
retrieve, these will be combined by logical AND. You may also supply a
C<orderby> argument, which is an expression used to determine the
order of entries returned. Usually, it would be a simple string with
the field name to use, e.g. C<'timestamp'>, but you might want to
append the keyword "C<DESC>" to it for descending order. Finally, you
may supply a C<entries> argument, which is the maximum number of
entries to retrieve.

It will retrieve the data, and then call C<populate()> for each of the
records retrieved to ensure that the plural data objects actually
consists of an array of L<AxKit::App::TABOO::Data::Story>s. But it
calls the internal C<_load()>-method to do the hard work (and that's
in the parent class).

If there is no data that corresponds to the given arguments, this method will return C<undef>.

=cut


sub load {
  my ($self, %args) = @_;
  my @stories;
  my $data = $self->_load(%args); # Does the hard work
  return undef unless (@{$data});
  foreach my $entry (@{$data}) {
    my $story = AxKit::App::TABOO::Data::Story->new();
    $story->populate($entry);
    $story->onfile;
    push(@stories, $story);
  }
  ${$self}{ENTRIES} = \@stories;
  return $self;
}

=back

=head1 BUGS/TODO

Not anything particular at the moment...


=head1 FORMALITIES

See L<AxKit::App::TABOO>.

=cut

1;


