=head1 NAME

SPVM::Document::Modules - SPVM Standard Modules

=head1 DESCRIPTION

The list of SPVM Standard Modules.

=head1 STANDARD MODULES

=over 2

=item * L<Fn|SPVM::Fn> - Standard Functions

=item * L<Byte|SPVM::Byte> - byte Object

=item * L<ByteList|SPVM::ByteList> - Dynamic byte Array

=item * L<Cloner|SPVM::Cloner> - A Callback Type to Clone a Object

=item * L<Cloneable|SPVM::Cloneable> - A Interface Type to Clone a Object

=item * L<Comparator::Byte|SPVM::Comparator::Byte> - A Callback Type for byte Comparation

=item * L<Comparator::Short|SPVM::Comparator::Short> - A Callback Type for short Comparation

=item * L<Comparator::Int|SPVM::Comparator::Int> - A Callback Type for int Comparation

=item * L<Comparator::Long|SPVM::Comparator::Long> - A Callback Type for long Comparation

=item * L<Comparator::Float|SPVM::Comparator::Float> - A Callback Type for float Comparation

=item * L<Comparator::Double|SPVM::Comparator::Double> - A Callback Type for double Comparation

=item * L<Comparator::String|SPVM::Comparator::String> - A Callback Type for string Comparation

=item * L<Comparator::Object|SPVM::Comparator::Object> - A Callback Type for object Comparation

=item * L<Complex_2d|SPVM::Complex_2d> - double Complex Type

=item * L<Complex_2f|SPVM::Complex_2f> - float Complex Type

=item * L<Double|SPVM::Double> - double Object

=item * L<DoubleList|SPVM::DoubleList> - Dynamic double Array

=item * L<EqualityChecker|SPVM::EqualityChecker> - A Callback Type to Check the Object Equality

=item * L<EqualityChecker::SameObject|SPVM::EqualityChecker::SameObject> - A Implementation of L<EqualityChecker|SPVM::EqualityChecker> to Check if the Memory Addresses of the Two Objects are Equal.

=item * L<Float|SPVM::Float> - float Object

=item * L<FloatList|SPVM::FloatList> - Dynamic float Array

=item * L<Hash|SPVM::Hash> - Hash Data Structure

=item * L<Hash::Entry|SPVM::Hash::Entry> - Hash Entry

=item * L<Int|SPVM::Int> - int Object

=item * L<IntList|SPVM::IntList> - Dynamic int Array

=item * L<List|SPVM::List> - Dynamic Object Array

=item * L<Long|SPVM::Long> - long Object

=item * L<LongList|SPVM::LongList> - Dynamic long Array

=item * L<Regex|SPVM::Regex> - Regular Expression

=item * L<Regex::Pattern|SPVM::Regex::Pattern> - Regular Expression Pattern

=item * L<Regex::Replacer|SPVM::Regex::Replacer> - Regular Expression Replacer

=item * L<Short|SPVM::Short> - short Object

=item * L<ShortList|SPVM::ShortList> - Dynamic short Array

=item * L<StringBuffer|SPVM::StringBuffer> - String Buffer

=item * L<Stringable|SPVM::Stringable> - A Interface Type to Stringify a Object

=item * L<Stringer|SPVM::Stringer> - A Callback Type to Stringify a Object

=item * L<StringList|SPVM::StringList> - Dynamic string Array

=item * L<Time|SPVM::Time> - Time Manipulation

=item * L<Time::Info|SPVM::Time::Info> - Time Information

=item * L<Unicode|SPVM::Unicode> - Unicode Utilities

=back

=head1 CPAN MODULES

The list of some CPAN modules.

=over 2

=item * L<Math|SPVM::Math> - Math functions

=item * L<JSON|SPVM::JSON> - JSON

=back
